package in.oliveboard.sdk.log;

import android.util.Log;


public class DefaultLogger implements Logger {

    private int logLevel;

    public DefaultLogger(int logLevel) {
        this.logLevel = logLevel;
    }

    public DefaultLogger() {
        this.logLevel = DebugMonitor.LOG_LEVEL.DEBUG;
    }

    public boolean isLoggable(String tag, int level) {
        return this.logLevel <= level;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void d(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable())
        {
            if (this.isLoggable(tag, 3)) {
                Log.d(tag, message, throwable);
            }
    }

    }


    public void v(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable()) {
            if (this.isLoggable(tag, 2)) {
                Log.v(tag, message, throwable);
            }
        }

    }

    public void i(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable()) {
            if (this.isLoggable(tag, 4)) {
                Log.i(tag, message, throwable);
            }
        }

    }

    public void w(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable()) {
            if (this.isLoggable(tag, 5)) {
                Log.w(tag, message, throwable);
            }
        }

    }

    public void e(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable()) {
            if (this.isLoggable(tag, 6)) {
                Log.e(tag, message, throwable);
            }
        }

    }

    public void d(String tag, String message) {
        this.d(tag, message, (Throwable)null);
    }

    public void v(String tag, String message) {
        this.v(tag, message, (Throwable)null);
    }

    public void i(String tag, String message) {
        this.i(tag, message, (Throwable)null);
    }

    public void w(String tag, String message) {
        this.w(tag, message, (Throwable)null);
    }

    public void e(String tag, String message) {
        this.e(tag, message, (Throwable)null);
    }

    public void log(int priority, String tag, String message) {
        this.log(priority, tag, message, false);
    }

    public void log(int priority, String tag, String message, boolean forceLog) {
        if(forceLog || this.isLoggable(tag, priority)) {
            Log.println(priority, tag, message);
        }

    }
}