package in.oliveboard.sdk.log;

import android.util.Log;

public class DebugMonitor {

    //Default Logging mode enabled
    static Logger LOGGER = new DefaultLogger();

    static volatile DebugMonitor debugMonitor;

    public static boolean debug = false;

    public static synchronized DebugMonitor getInstance() {
        if (debugMonitor == null) {
            debugMonitor = new DebugMonitor();
        }
        return debugMonitor;
    }



    /*Log Level Options*/
    public static class LOG_LEVEL {
        public static int

                ERROR=Log.ERROR,
                WARN=Log.WARN,
                INFO=Log.INFO,
                DEBUG=Log.DEBUG,
                VERBOSE= Log.VERBOSE;

    }




    /*Enabling debugging during development*/
    public static void setLogEnabled(int logLevel) {
        debug = true;
        LOGGER = new DefaultLogger(logLevel);
    }

    /*Check Whether debugging is enabled*/
    public static boolean isDebuggable() {
        return debug;
    }
    public static Logger getLogger() {
        return LOGGER;
    }
}
