/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.utils;

import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.PauseTestInfo;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.SubmitTestInfo;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestDialogInfo;
import in.oliveboard.sdk.utils.Constants;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.TreeMap;

public class FilterQuestions {
    private static FilterQuestions filterquestions;

    public static synchronized FilterQuestions getInstance() {
        if (filterquestions == null) {
            filterquestions = new FilterQuestions();
        }
        return filterquestions;
    }

    public ArrayList<FilterModel> filter(ArrayList<TestAppModel> questionDataList, int filterOption) {
        ArrayList<TestAppModel> filterArrayList = new ArrayList<TestAppModel>();
        ArrayList<FilterModel> filterData = new ArrayList<FilterModel>();
        TreeMap<Integer, SectionKeyValue> sectionSort = new TreeMap<Integer, SectionKeyValue>();
        int sectionSortKey = 0;
        int newIndex = 0;
        String oldKey = "";
        if (filterOption == 0) {
            filterData.add(new FilterModel(questionDataList, null));
            return filterData;
        }
        if (filterOption == 1) {
            for (int i = 0; i < questionDataList.size(); ++i) {
                if (questionDataList.get(i).getSelectionOption() == -1) continue;
                if (!oldKey.equals(questionDataList.get(i).getKey())) {
                    oldKey = questionDataList.get(i).getKey();
                    DebugMonitor.getLogger().d("key taken", oldKey + " position " + sectionSortKey);
                    sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                    ++sectionSortKey;
                }
                ++newIndex;
                filterArrayList.add(questionDataList.get(i));
            }
        } else if (filterOption == 2) {
            for (int i = 0; i < questionDataList.size(); ++i) {
                if (questionDataList.get(i).getSelectionOption() != -1) continue;
                filterArrayList.add(questionDataList.get(i));
                if (!oldKey.equals(questionDataList.get(i).getKey())) {
                    oldKey = questionDataList.get(i).getKey();
                    sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                    ++sectionSortKey;
                }
                ++newIndex;
            }
        } else if (filterOption == 3) {
            for (int i = 0; i < questionDataList.size(); ++i) {
                if (!questionDataList.get(i).isFavorite()) continue;
                filterArrayList.add(questionDataList.get(i));
                if (!oldKey.equals(questionDataList.get(i).getKey())) {
                    oldKey = questionDataList.get(i).getKey();
                    sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                    ++sectionSortKey;
                }
                ++newIndex;
            }
        } else if (filterOption == Constants.FILTER_CORRECT_TYPE) {
            for (int i = 0; i < questionDataList.size(); ++i) {
                if (!((String)((ArrayList)questionDataList.get(i).getTestInfo().get(6)).get(0)).equals((String)((ArrayList)questionDataList.get(i).getTestInfo().get(6)).get(2))) continue;
                if (!oldKey.equals(questionDataList.get(i).getKey())) {
                    oldKey = questionDataList.get(i).getKey();
                    DebugMonitor.getLogger().d("key taken", oldKey + " position " + sectionSortKey);
                    sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                    ++sectionSortKey;
                }
                ++newIndex;
                filterArrayList.add(questionDataList.get(i));
            }
        } else if (filterOption == Constants.FILTER_WRONG_TYPE) {
            for (int i = 0; i < questionDataList.size(); ++i) {
                if (((String)((ArrayList)questionDataList.get(i).getTestInfo().get(6)).get(2)).toLowerCase().equals(Constants.UNATTEMPTED) || ((String)((ArrayList)questionDataList.get(i).getTestInfo().get(6)).get(0)).equals((String)((ArrayList)questionDataList.get(i).getTestInfo().get(6)).get(2))) continue;
                if (!oldKey.equals(questionDataList.get(i).getKey())) {
                    oldKey = questionDataList.get(i).getKey();
                    DebugMonitor.getLogger().d("key taken", oldKey + " position " + sectionSortKey);
                    sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                    ++sectionSortKey;
                }
                ++newIndex;
                filterArrayList.add(questionDataList.get(i));
            }
        } else if (filterOption == Constants.FILTER_UN_ATTEMPTED_TYPE) {
            for (int i = 0; i < questionDataList.size(); ++i) {
                if (!((String)((ArrayList)questionDataList.get(i).getTestInfo().get(6)).get(2)).toLowerCase().equals(Constants.UNATTEMPTED)) continue;
                if (!oldKey.equals(questionDataList.get(i).getKey())) {
                    oldKey = questionDataList.get(i).getKey();
                    DebugMonitor.getLogger().d("key taken", oldKey + " position<<>> " + sectionSortKey);
                    sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                    ++sectionSortKey;
                }
                ++newIndex;
                filterArrayList.add(questionDataList.get(i));
            }
        }
        filterData.add(new FilterModel(filterArrayList, sectionSort));
        return filterData;
    }

    public ArrayList<TestDialogInfo> getSummeryInfo(ArrayList<TestAppModel> data) {
        int attempted = 0;
        int unattempted = 0;
        int favourite = 0;
        LinkedHashMap<String, SubmitTestInfo> submitMap = new LinkedHashMap<String, SubmitTestInfo>();
        if (data != null) {
            for (int k = 0; k < data.size(); ++k) {
                if (data.get(k).getAllSessionData() != null && data.get(k).getAllSessionData().size() > 0) {
                    submitMap.put(data.get(k).getQuestionId(), new SubmitTestInfo(data.get(k).getQuestionId(), data.get(k).getSelectionOption() == -1 ? "" : Integer.toString(data.get(k).getSelectionOption() + 1), data.get(k).getAllSessionData()));
                }
                if (data.get(k).isFavorite()) {
                    ++favourite;
                }
                if (data.get(k).getSelectionOption() == -1) {
                    ++unattempted;
                    continue;
                }
                ++attempted;
            }
        }
        ArrayList<TestDialogInfo> filterSummeryList = new ArrayList<TestDialogInfo>();
        filterSummeryList.add(new TestDialogInfo(attempted, favourite, unattempted, submitMap));
        return filterSummeryList;
    }

    public LinkedHashMap<String, PauseTestInfo> getPauseTestInfo(ArrayList<TestAppModel> data) {
        LinkedHashMap<String, PauseTestInfo> submitMap = new LinkedHashMap<String, PauseTestInfo>();
        for (int k = 0; k < data.size(); ++k) {
            if (data.get(k).getAllSessionData().size() <= 0) continue;
            submitMap.put(data.get(k).getQuestionId(), new PauseTestInfo(data.get(k).getQuestionId(), data.get(k).getSelectionOption() == -1 ? "" : Integer.toString(data.get(k).getSelectionOption() + 1), data.get(k).getAllSessionData(), data.get(k).isFavorite() ? "11" : ""));
        }
        return submitMap;
    }

    public String getDurationString(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return this.twoDigitString(hours) + ":" + this.twoDigitString(minutes) + ":" + this.twoDigitString(seconds %= 60L);
    }

    private String twoDigitString(long number) {
        if (number == 0L) {
            return "00";
        }
        if (number / 10L == 0L) {
            return "0" + number;
        }
        return String.valueOf(number);
    }

    public int getQuestionSection(TreeMap<Integer, SectionKeyValue> questionSet, String key) {
        for (int i = 0; i < questionSet.size(); ++i) {
            if (!questionSet.get(i).getKey().equals(key)) continue;
            return i;
        }
        return 0;
    }
}

