/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.fragments;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.ui.adapters.SolutionFilterAdapter;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.FilterAsyncTask;
import in.oliveboard.sdk.utils.FilterInterface;
import in.oliveboard.sdk.utils.RecyclerItemClickListener;
import java.util.ArrayList;
import java.util.Objects;

public class SolutionAppFilterFragment
extends Fragment
implements FilterInterface {
    RecyclerView recyclerView;
    ArrayList<TestAppModel> questionDataList;
    ArrayList<TestAppModel> filterArrayList = new ArrayList();

    public static SolutionAppFilterFragment newInstance(int index) {
        SolutionAppFilterFragment fragment = new SolutionAppFilterFragment();
        Bundle args = new Bundle();
        args.putInt(Constants.INDEX, index);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.recycler_fragment, container, false);
        this.recyclerView = (RecyclerView)v.findViewById(R.id.recycler_view_fragment);
        return v;
    }

    @RequiresApi(api=19)
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.questionDataList = ((App)Objects.requireNonNull(this.getActivity()).getApplicationContext()).getBaseFilterArray();
        if (this.questionDataList != null) {
            assert (this.getArguments() != null);
            if (this.getArguments().getInt(Constants.INDEX) == 0) {
                this.filterArrayList.clear();
                this.filterArrayList.addAll(this.questionDataList);
                SolutionFilterAdapter adapter = new SolutionFilterAdapter(this.filterArrayList, (Context)this.getActivity(), this.getArguments().getInt(Constants.INDEX), ((App)this.getActivity().getApplicationContext()).getLanguageType());
                this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
                this.recyclerView.setHasFixedSize(true);
                this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
            } else if (this.getArguments().getInt(Constants.INDEX) == Constants.FILTER_CORRECT) {
                new FilterAsyncTask((App)this.getActivity().getApplicationContext(), 0, Constants.FILTER_CORRECT_TYPE, this.questionDataList, this, 0).execute(new Void[0]);
            } else if (this.getArguments().getInt(Constants.INDEX) == Constants.FILTER_UN_ATTEMPTED) {
                new FilterAsyncTask((App)this.getActivity().getApplicationContext(), 0, Constants.FILTER_UN_ATTEMPTED_TYPE, this.questionDataList, this, 0).execute(new Void[0]);
            } else if (this.getArguments().getInt(Constants.INDEX) == Constants.FILTER_WRONG) {
                new FilterAsyncTask((App)this.getActivity().getApplicationContext(), 0, Constants.FILTER_WRONG_TYPE, this.questionDataList, this, 0).execute(new Void[0]);
            }
        } else {
            this.getActivity().finish();
        }
        this.recyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerItemClickListener((Context)this.getActivity(), this.recyclerView, new RecyclerItemClickListener.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                Intent returnIntent = new Intent();
                returnIntent.putExtra("com.activity.result.filter.type", SolutionAppFilterFragment.this.getArguments().getInt(Constants.INDEX));
                returnIntent.putExtra("com.act.result.pos.filter", position);
                SolutionAppFilterFragment.this.getActivity().setResult(-1, returnIntent);
                SolutionAppFilterFragment.this.getActivity().finish();
            }

            @Override
            public void onItemLongClick(View view, int position) {
            }
        }));
    }

    @Override
    @RequiresApi(api=19)
    public void ongetFilterResult(ArrayList<FilterModel> filterData, int position) {
        if (filterData != null && filterData.size() > 0) {
            this.filterArrayList.clear();
            this.filterArrayList.addAll(filterData.get(0).getFilterArrayList());
            assert (this.getArguments() != null);
            SolutionFilterAdapter adapter = new SolutionFilterAdapter(this.filterArrayList, (Context)this.getActivity(), this.getArguments().getInt(Constants.INDEX), ((App)Objects.requireNonNull(this.getActivity()).getApplicationContext()).getLanguageType());
            this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
            this.recyclerView.setHasFixedSize(true);
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        }
    }
}

