/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.communication;

import android.os.AsyncTask;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.utils.BaseSharedPreferences;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public final class HTTPAsyncTaskMockSectional
extends AsyncTask<String, Void, String> {
    String url;
    BaseCallback callback;
    BaseSharedPreferences baseSharedPreferences;
    String cookieAuthtoken;
    String cookieVersion;
    String cookieDeviceid;

    public HTTPAsyncTaskMockSectional(String url, String cookieAuthtoken, String cookieVersion, String cookieDeviceid, BaseCallback callback) {
        this.url = url;
        this.cookieAuthtoken = cookieAuthtoken;
        this.cookieVersion = cookieVersion;
        this.cookieDeviceid = cookieDeviceid;
        this.callback = callback;
    }

    protected String doInBackground(String ... urls) {
        try {
            return this.performPostCall(this.url, this.cookieAuthtoken, this.cookieVersion, this.cookieDeviceid);
        }
        catch (Exception e) {
            return "Unable to retrieve web page. URL may be invalid.";
        }
    }

    protected void onPostExecute(String result) {
        Log.d((String)"ush", (String)("HTTPAsyncTaskMockSectional asynnnnnnnnnnnnnnnnnnnnnnnn  " + result));
        ArrayList mockSectionalResponseModel = (ArrayList)new Gson().fromJson(result, new TypeToken<ArrayList<Object>>(){}.getType());
        this.callback.onSuccess(mockSectionalResponseModel);
        Log.d((String)"ush", (String)("HTTPAsyncTaskMockSectional asynnnnnnnnnnnnnnnnnnnnnnnnuauth  " + mockSectionalResponseModel.size()));
    }

    public String performPostCall(String requestURL, String cookieAuthtoken, String cookieVersion, String cookieDeviceid) {
        InputStream inputStream = null;
        String response = "";
        try {
            URL url = new URL(requestURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("POST");
            conn.addRequestProperty("Cookie", cookieAuthtoken);
            conn.addRequestProperty("X-version", cookieVersion);
            conn.addRequestProperty("X-deviceid", cookieDeviceid);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.flush();
            writer.close();
            os.close();
            int responseCode = conn.getResponseCode();
            response = responseCode == 200 ? ((inputStream = conn.getInputStream()) != null ? this.convertInputStreamToString(inputStream) : "Did not work!") : "";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private String convertInputStreamToString(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String line = "";
        String result = "";
        while ((line = bufferedReader.readLine()) != null) {
            result = result + line;
        }
        inputStream.close();
        return result;
    }
}

