package in.oliveboard.sdk.utils;

import android.os.AsyncTask;

import java.util.ArrayList;

import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.TestAppModel;


public class FilterAsyncTask extends AsyncTask<Void, Integer, String> {
    ArrayList<TestAppModel> filterArrayList = new ArrayList<>();
    ArrayList<TestAppModel> questionDataList;
    App applicationContext;
    int filterKey;
    FilterInterface filterInterface;
    ArrayList<FilterModel> filterInfo = new ArrayList<>();
    int position;
    int filterMode;

    public FilterAsyncTask(App applicationContext, int filterMode, int filterKey, ArrayList<TestAppModel> questionDataList, FilterInterface filterInterface, int position) {
        this.applicationContext = applicationContext;
        this.filterKey = filterKey;
        this.questionDataList = questionDataList;
        this.filterInterface = filterInterface;
        this.position = position;
        this.filterMode = filterMode;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected String doInBackground(Void... arg0) {

        if (filterMode == 0) {
            if (applicationContext.getSolutionfilter(filterKey) == null) {
//        Log.d("going for", "filterLoop" + filterKey);
                filterInfo = FilterQuestions.getInstance().filter(questionDataList, filterKey);
                applicationContext.setSolutionfilter(filterKey, filterInfo);
            } else {
//        Log.d("going for", "filtercache" + filterKey);

                filterInfo = applicationContext.getSolutionfilter(filterKey);
            }
        } else {
            filterInfo = FilterQuestions.getInstance().filter(questionDataList, filterKey);
            applicationContext.setSolutionfilter(filterKey, filterInfo);
        }

        return null;
    }


    protected void onPostExecute(String result) {
        super.onPostExecute(result);
        if (filterInterface != null) {
            if(filterInfo!=null&&filterInfo.size()>0&&filterInfo.get(0).getFilterArrayList()!=null)
            {
                filterInterface.ongetFilterResult(filterInfo, position);
            }
        }

    }
}