package in.oliveboard.sdk.ui.fragments;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.Objects;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.ui.adapters.TestFilterAdapter;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.FilterAsyncTask;
import in.oliveboard.sdk.utils.FilterInterface;
import in.oliveboard.sdk.utils.RecyclerItemClickListener;


public class TestAppFilterFragment extends Fragment implements FilterInterface {
    RecyclerView recyclerView;
    ArrayList<TestAppModel> filterArrayList = new ArrayList<>();

    public static TestAppFilterFragment newInstance(int index){
        TestAppFilterFragment fragment=new TestAppFilterFragment();
        Bundle args = new Bundle();
        args.putInt(Constants.INDEX,index);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v=inflater.inflate(R.layout.recycler_fragment, container,false);
        recyclerView = v.findViewById(R.id.recycler_view_fragment);

        return v;
    }
    ArrayList<TestAppModel> questionDataList;
    @TargetApi(Build.VERSION_CODES.KITKAT)
    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        questionDataList=((App) Objects.requireNonNull(getActivity()).getApplicationContext()).getBaseFilterArray();
        if(questionDataList!=null) {


            assert getArguments() != null;
            if (getArguments().getInt(Constants.INDEX) == Constants.TYPE_ALL) {
                filterArrayList.clear();
                filterArrayList.addAll(questionDataList);

                TestFilterAdapter adapter = new TestFilterAdapter(filterArrayList, getActivity(), getArguments().getInt(Constants.INDEX), (((App) getActivity().getApplicationContext()).getLanguageType()));

                recyclerView.setAdapter(adapter);
                recyclerView.setHasFixedSize(true);
                recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
            } else if (getArguments().getInt(Constants.INDEX) == Constants.TYPE_ATTEMPTED) {
                new FilterAsyncTask(((App)getActivity().getApplicationContext()),1, Constants.TYPE_ATTEMPTED,questionDataList,this,0).execute();

//                filterArrayList.addAll(FilterQuestions.getInstance().filter(questionDataList, Constants.TYPE_ATTEMPTED).get(0).getFilterArrayList());
            } else if (getArguments().getInt(Constants.INDEX) == Constants.TYPE_UNATTEMPTED) {
                new FilterAsyncTask(((App)getActivity().getApplicationContext()),1, Constants.TYPE_UNATTEMPTED,questionDataList,this,0).execute();

//                filterArrayList.addAll(FilterQuestions.getInstance().filter(questionDataList, Constants.TYPE_UNATTEMPTED).get(0).getFilterArrayList());

            } else if (getArguments().getInt(Constants.INDEX) == Constants.TYPE_FAV) {
                new FilterAsyncTask(((App)getActivity().getApplicationContext()),1, Constants.TYPE_FAV,questionDataList,this,0).execute();

//                filterArrayList.addAll(FilterQuestions.getInstance().filter(questionDataList, Constants.TYPE_FAV).get(0).getFilterArrayList());

            }

            recyclerView.addOnItemTouchListener(
                    new RecyclerItemClickListener(getActivity(), recyclerView, new RecyclerItemClickListener.OnItemClickListener() {
                        @Override
                        public void onItemClick(View view, int position) {
                            Intent returnIntent = new Intent();
                            returnIntent.putExtra(Constants.FILTER_TYPE, getArguments().getInt(Constants.INDEX));
                            returnIntent.putExtra(Constants.FILTER_POSITION, position);
                            getActivity().setResult(Activity.RESULT_OK, returnIntent);
                            getActivity().finish();
                        }

                        @Override
                        public void onItemLongClick(View view, int position) {

                        }
                    })
            );
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public void ongetFilterResult(ArrayList<FilterModel> filterData, int position) {
        if(filterData!=null&&filterData.size()>0) {
            filterArrayList.clear();
            filterArrayList .addAll( filterData.get(0).getFilterArrayList());
            assert getArguments() != null;
            TestFilterAdapter adapter = new TestFilterAdapter(filterArrayList, getActivity(), getArguments().getInt(Constants.INDEX), (((App) Objects.requireNonNull(getActivity()).getApplicationContext()).getLanguageType()));

            recyclerView.setAdapter(adapter);
            recyclerView.setHasFixedSize(true);
            recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
        }
    }
}
