package in.oliveboard.sdk.ui.adapters;

import android.content.Context;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;

import java.util.ArrayList;

import in.oliveboard.sdk.R;


public class GridExamsAdapter extends RecyclerView.Adapter<GridExamsAdapter.ViewHolder> {

    private ArrayList<ArrayList<String>> mExamsInfo;
    private Context mContext;
    private ItemClickListener itemClickListener;
    private int parentPosition;

    public GridExamsAdapter(Context context, ItemClickListener clickListener, int position, ArrayList<ArrayList<String>> examsInfo) {
        this.mContext = context;
        this.itemClickListener = clickListener;
        this.parentPosition = position;
        this.mExamsInfo = examsInfo;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_item_exams, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, final int position) {
        holder.examTitle.setText(mExamsInfo.get(position).get(0));
        holder.subTitles.setText(mExamsInfo.get(position).get(2));
        Glide.with(mContext).load(mExamsInfo.get(position).get(1))
                .placeholder(R.drawable.ic_placeholder_square).into(holder.testImageView);

        /*if(mExamsInfo.get(position).get(0).contains("SBI")) {
            Glide.with(mContext).load(R.drawable.ic_logo_sbi_new).into(holder.testImageView);
        } else if(mExamsInfo.get(position).get(0).contains("RRB")) {
            Glide.with(mContext).load(R.drawable.ic_logo_rrb).into(holder.testImageView);
        } else {
            Glide.with(mContext).load(mExamsInfo.get(position).get(1)).into(holder.testImageView);
        }*/

        holder.examsCard.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                itemClickListener.onItemClick(position, parentPosition);
            }
        });
    }

    @Override
    public int getItemCount() {
        return mExamsInfo.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        TextView examTitle;
        TextView subTitles;
        ImageView testImageView;
        CardView examsCard;

        ViewHolder(View itemView) {
            super(itemView);
            examTitle = (TextView) itemView.findViewById(R.id.bind_exams_title);
            subTitles = (TextView) itemView.findViewById(R.id.bind_exams_msg);
            testImageView = (ImageView) itemView.findViewById(R.id.test_image_view);

            examsCard = (CardView) itemView.findViewById(R.id.bind_exams_card);
        }

        @Override
        public void onClick(View view) {

        }
    }

    public interface ItemClickListener {
        void onItemClick(int position, int parentPosition);
    }
}
