package in.oliveboard.sdk.ui;

import android.os.Bundle;
import android.support.design.widget.TabLayout;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;


import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.ReCheckWallet;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.WalletPlanInfo;
import in.oliveboard.sdk.ui.adapters.PlanViewpagerAdaptor;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.onDialogUtilCalled;


public class TestUpgradeActivity extends BaseActivity implements CommonContract.View,onDialogUtilCalled {
    Toolbar toolbar;
    ViewPager viewPager;
    TabLayout tabs;

    TestPresenter presenter = new TestPresenter();
    @Override
    protected void initializeDagger() {
        App app = (App) getApplicationContext();

        toolbar = findViewById(R.id.toolbar);
        viewPager = findViewById(R.id.upgrade_viewpager);
        tabs = findViewById(R.id.upgrade_tabs);

        toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        setSupportActionBar(toolbar);
        setBackEnabled(true);
        try {
            if (getIntent().getExtras() != null && getIntent().getExtras().containsKey("spec_name")) {
                setTitle(getIntent().getExtras().getString("spec_name"));
            } else {
                if (((App) getApplicationContext()).getLang().equals("hi")) {
                    setTitle(R.string.nav_store_txt_hindi);
                } else {
                    setTitle(R.string.nav_store_txt);
                }
            }
        }
        catch (Exception e)
        {
            if (((App) getApplicationContext()).getLang().equals("hi")) {
                setTitle(R.string.nav_store_txt_hindi);
            } else {
                setTitle(R.string.nav_store_txt);
            }
        }



//
//        if(getIntent().getExtras()!=null&&getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_PAYMENT_URL)) {
//
//            viewPager.setAdapter(new PlanViewpagerAdaptor(getSupportFragmentManager(), getIntent().getExtras().getString(Constants.BUNDLE_KEY_PAYMENT_URL), getIntent().getExtras().getString(Constants.BUNDLE_KEY_COMBO_PAYMENT_URL)));
//
//        }
//        else
//        {
//
//            viewPager.setAdapter(new PlanViewpagerAdaptor(getSupportFragmentManager(), "",""));
//
//        }
//        tabs.setupWithViewPager(viewPager);
//        BasicConfig.getInstance().apply((ViewGroup) tabs.getChildAt(0),"fonts/SF-UI-Display_Heavy_Cyrillic.otf",getApplicationContext());


    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);
        if (getIntent().getExtras().containsKey(Constants.PAYMENT_TYPE)) {

            showProgressDialog(getString(R.string.str_please_wait));
            if(presenter!=null) {
                presenter.callWalletPlan(getIntent().getExtras().getString(Constants.PAYMENT_TYPE));
            }

        }

    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_upgrade;
    }

    @Override
    public void onSuccess(Object responseModel) {
        if (!isFinishing()) {
            hideProgressDialog();
            if (responseModel != null) {
                if (responseModel instanceof WalletPlanInfo) {

                    viewPager.setAdapter(new PlanViewpagerAdaptor(getSupportFragmentManager(), ((WalletPlanInfo) responseModel)));
                    tabs.setupWithViewPager(viewPager);
                    BasicConfig.getInstance().apply((ViewGroup) tabs.getChildAt(0),"fonts/SF-UI-Display_Heavy_Cyrillic.otf",getApplicationContext());

                }
            }
        }

    }

    @Override
    public void onFailed() {

    }

    @Override
    public void onSuccess(List responseModel) {

    }

    @Override
    public void onFailed(String message) {
        hideProgressDialog();
        if (viewPager != null && viewPager.getChildCount() == 0) {
            if (!isFinishing()) {
                DialogUtils.getInstance().singleDialog(TestUpgradeActivity.this, "check the network status and try again", "No Connectivity", "Ok", this);
            }
        }
    }

    @Override
    public void onAuthFailed() {

        BasicConfig.getInstance().onAuthFailed(this);

    }

    @Override
    public void onSuccess(String response) {

    }

    @Override
    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {

    }

    @Override
    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {

    }

    @Override
    public void onOptionDialogSelected(int position) {

    }

    @Override
    public void onAutoDialogSelected() {

    }

    @Override
    public void onSubmitDialogSelected() {

    }

    @Override
    public void onExitApp() {
        finish();
    }

    @Override
    public void onExitWithoutPause() {

    }

    @Override
    public void onTryAgain() {

    }

    @Override
    public void onPauseTest(boolean value) {

    }

    @Override
    public void startTest(boolean value) {

    }

    @Override
    public void retyPermission() {

    }

    @Override
    public void gotoPurchase() {

    }

    @Override
    public void noPhoneAction() {

    }

    @Override
    public void openPermissionSetting() {

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MainEventBus.getInstance().post(new ReCheckWallet());

    }
}
