package in.oliveboard.sdk.timer;

import android.annotation.SuppressLint;
import android.os.CountDownTimer;
import android.widget.TextView;


import java.io.IOException;

import in.oliveboard.sdk.timer.listener.TimerListener;


public class OliveBoardWalletTimer {

    private static final long WARNING_TIME = 180000;//set for 3 min now
    private TextView timerTextView;
    private Counter counterConfig;
    @SuppressLint("StaticFieldLeak")
    private static OliveBoardWalletTimer oliveBoradInstance;
    private TimerListener timerListener;
    private CountDownTimer countDowmTimer;
    private long lastmillisecound = 0;
    private boolean isTicking = false;

    public static synchronized OliveBoardWalletTimer getInstance() {
        if (oliveBoradInstance == null) {
            oliveBoradInstance = new OliveBoardWalletTimer();
        }
        return oliveBoradInstance;
    }

    public OliveBoardWalletTimer init(TextView timerTextView, Counter counterConfig, TimerListener timerListener) {
        this.timerTextView = timerTextView;
        this.counterConfig = counterConfig;
        this.timerListener = timerListener;
        return this;
    }

    public OliveBoardWalletTimer init(Counter counterConfig, TimerListener timerListener) {
        this.counterConfig = counterConfig;
        this.timerListener = timerListener;
        return this;
    }

    public OliveBoardWalletTimer init(TimerListener timerListener) {
        this.timerListener = timerListener;
        return this;
    }

    public void startTimer(boolean isResume) throws IOException {
//        if(timerTextView!=null)
//        {
        if (isTicking && countDowmTimer != null) {
            countDowmTimer.cancel();
        }
        if (counterConfig.getTotalTime() != 0 || lastmillisecound != 0) {
            long secoundtoMilleSecound = isResume ? lastmillisecound : counterConfig.getTotalTime() * 1000;

            if (!isTicking) {

                isTicking = true;
                countDowmTimer = new CountDownTimer(secoundtoMilleSecound, 1000) {

                    int mDisplayHours;
                    private int mDisplayMinutes;
                    private int mDisplaySeconds;

                    @Override
                    public void onTick(long millisUntilFinished) {
                        // converts into  hours, minutes and seconds
                        lastmillisecound = millisUntilFinished;
                        mDisplayHours = (int) (((millisUntilFinished / 1000)) / 3600);
                        mDisplayMinutes = (int) (((millisUntilFinished / 1000) - (mDisplayHours * 3600)) / 60);
                        mDisplaySeconds = (int) ((millisUntilFinished / 1000) % 60);
                        if (timerListener != null) {
                            timerListener.onLiveTimeRunning(((mDisplayHours < 10) ? " 0" + mDisplayHours : (mDisplayHours < 100) ? " " + mDisplayHours : mDisplayHours) + ":" + ((mDisplayMinutes < 10) ? "0" + mDisplayMinutes : mDisplayMinutes) + ":" + ((mDisplaySeconds < 10) ? "0" + mDisplaySeconds : mDisplaySeconds));
                        }
//                            Log.d("Ticking", "AM Ticking..."+millisUntilFinished);
                        if (millisUntilFinished < WARNING_TIME) {
                            if (timerListener != null) {
                                timerListener.onTimerChanged(TimerStatus.TIME_ENDING);
                            }
                        }
                    }

                    @Override
                    public void onFinish() {
                        if (timerListener != null) {
                            timerListener.onLiveTimeRunning("00:00:00");
                            lastmillisecound = 0;
                            timerListener.onTimerChanged(TimerStatus.FINISHED);
                        }
                    }


                }.start();
            }

        } else {
            //Todo write timer exception handling
            throw new IOException("starting time cannot be 0");
        }
//        }
//        else
//        {
//            //Todo write view exception handling
//            throw new NullPointerException("textview is null");
//
//        }
    }

    public void pause() {
        if (isTicking) {
            if (countDowmTimer != null) {
                countDowmTimer.cancel();
                if (timerListener != null) {
                    timerListener.onTimerChanged(TimerStatus.PAUSED);
                }
            }
            isTicking = false;
        }
    }

    public void resume() {
        if (!isTicking) {
            if (countDowmTimer != null) {

                try {
                    startTimer(true);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                if (timerListener != null) {
                    timerListener.onTimerChanged(TimerStatus.RESUMED);
                }

            }
        }
    }

    public void setTime() {
        if(counterConfig!=null) {
            long millisUntilFinished = (counterConfig.getTotalTime() - 1) * 1000;
            int mDisplayHours = (int) (((millisUntilFinished / 1000)) / 3600);
            int mDisplayMinutes = (int) (((millisUntilFinished / 1000) - (mDisplayHours * 3600)) / 60);
            int mDisplaySeconds = (int) ((millisUntilFinished / 1000) % 60);
            if (timerListener != null) {
                timerListener.onLiveTimeRunning(((mDisplayHours < 10) ? " 0" + mDisplayHours : (mDisplayHours < 100) ? " " + mDisplayHours : mDisplayHours) + ":" + ((mDisplayMinutes < 10) ? "0" + mDisplayMinutes : mDisplayMinutes) + ":" + ((mDisplaySeconds < 10) ? "0" + mDisplaySeconds : mDisplaySeconds));
            }
        }
    }

    public void finish() {
        isTicking = false;
        if (countDowmTimer != null) {
            countDowmTimer.cancel();
            lastmillisecound = 0;
            if(timerListener!=null) {
                timerListener.onTimerChanged(TimerStatus.FORCE_FINISHED);
            }

        }
    }


}
