/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.utils;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.LanguageNotifier;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.utils.LocaleContextWrapper;
import in.oliveboard.sdk.utils.MainEventBus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;

public class App
extends Application {
    private static Context context;
    ArrayList<TestAppModel> filterArray;
    TestResponseModel testResponseData;
    ArrayList<TestAppModel> questionAnswerInfo;
    TreeMap<Integer, SectionKeyValue> questionSet;
    int language = 0;
    boolean canEndSession = false;
    public ArrayList<TestAppModel> currentQuestionInfo = new ArrayList();
    LinkedHashMap<String, ArrayList<String>> panesList;
    HashMap<Integer, ArrayList<FilterModel>> solutionFilterList = new HashMap();
    int switchToQuestion;
    int questionSize = 0;
    boolean shouldShowTimer = false;
    String amount;
    boolean examRunning = false;
    public String walletIcon = "Some url";

    public void onCreate() {
        super.onCreate();
        context = this.getApplicationContext();
    }

    public static Context getContext() {
        return context;
    }

    public void setQuestionInfo(TestResponseModel testResonseData) {
        this.testResponseData = testResonseData;
    }

    public TestResponseModel getQuestionInfo() {
        return this.testResponseData;
    }

    public void setQuestionAnswerInfo(ArrayList<TestAppModel> questionAnswerInfo) {
        this.questionAnswerInfo = questionAnswerInfo;
    }

    public ArrayList<TestAppModel> getQuestionAnswerInfo() {
        return this.questionAnswerInfo;
    }

    public void setBaseFilterArray(ArrayList<TestAppModel> filterArray) {
        this.filterArray = filterArray;
    }

    public ArrayList<TestAppModel> getBaseFilterArray() {
        return this.filterArray;
    }

    public void setCurrentQuestionInfo(ArrayList<TestAppModel> currentQuestionInfo) {
        this.currentQuestionInfo.clear();
        this.currentQuestionInfo.addAll(currentQuestionInfo);
    }

    public int getLanguageType() {
        return this.language;
    }

    public void setLanguageType(int language) {
        this.language = language;
    }

    public ArrayList<TestAppModel> getCurrentQuestionInfo() {
        return this.currentQuestionInfo;
    }

    public boolean canEndSession() {
        return this.canEndSession;
    }

    public void setCanEndSession(boolean canEndSession) {
        this.canEndSession = canEndSession;
    }

    public void clearAllData() {
        if (this.questionSize > 0) {
            this.questionSize = 0;
        }
        if (this.filterArray != null) {
            this.filterArray.clear();
        }
        if (this.questionAnswerInfo != null) {
            this.questionAnswerInfo.clear();
        }
        if (this.panesList != null) {
            this.panesList.clear();
        }
        if (this.solutionFilterList != null) {
            this.solutionFilterList.clear();
        }
        this.canEndSession = false;
        this.language = 0;
    }

    public void setQuestionSet(TreeMap<Integer, SectionKeyValue> questionSet) {
        this.questionSet = questionSet;
    }

    public TreeMap<Integer, SectionKeyValue> getQuestionSet() {
        return this.questionSet;
    }

    public void setPanesList(LinkedHashMap<String, ArrayList<String>> panesList) {
        this.panesList = panesList;
    }

    public LinkedHashMap<String, ArrayList<String>> getPanesList() {
        return this.panesList;
    }

    public void setSolutionfilter(int key, ArrayList<FilterModel> filterData) {
        this.solutionFilterList.put(key, filterData);
    }

    public ArrayList<FilterModel> getSolutionfilter(int key) {
        return this.solutionFilterList.get(key);
    }

    public void switchToPauseQuestion(int switchToQuestion) {
        this.switchToQuestion = switchToQuestion;
    }

    public int getSwitchToQuestion() {
        return this.switchToQuestion;
    }

    public void setQuestionSize(int questionSize) {
        this.questionSize = questionSize;
    }

    public int getQuestionSize() {
        return this.questionSize;
    }

    public boolean isTimerShow() {
        return this.shouldShowTimer;
    }

    public void setTimerRunning(boolean shouldShowTimer) {
        this.shouldShowTimer = shouldShowTimer;
    }

    public void changeLang(String lang) {
        LocaleContextWrapper.wrap(context, lang);
        SharedPreferences.Editor ed = PreferenceManager.getDefaultSharedPreferences((Context)this).edit();
        ed.putString(this.getString(R.string.locale_lang), lang);
        ed.commit();
        MainEventBus.getInstance().post((Object)new LanguageNotifier());
    }

    public String getLang() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this).getString(this.getString(R.string.locale_lang), "");
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setExamRunning(boolean examRunning) {
        this.examRunning = examRunning;
    }

    public boolean getExamRunning() {
        return this.examRunning;
    }

    public String getWalletIcon() {
        return this.walletIcon;
    }

    public void setWalletIcon(String walletIcon) {
        this.walletIcon = walletIcon;
    }
}

