/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.design.widget.TabLayout;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.squareup.otto.Subscribe;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.ClearSession;
import in.oliveboard.sdk.presenter.model.MockDataModel;
import in.oliveboard.sdk.presenter.model.OtherTestDataModel;
import in.oliveboard.sdk.presenter.model.RefreshTestInfo;
import in.oliveboard.sdk.presenter.model.SessionOut;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.TestStatusEventModel;
import in.oliveboard.sdk.presenter.model.TimeInfo;
import in.oliveboard.sdk.presenter.model.UpdateTestCount;
import in.oliveboard.sdk.presenter.model.WalletVisibility;
import in.oliveboard.sdk.ui.HomeActivity;
import in.oliveboard.sdk.ui.TestUpgradeActivity;
import in.oliveboard.sdk.ui.adapters.BaseModuleAdaptor;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.MainEventBus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

public class MockTestActivity
extends BaseActivity
implements CommonContract.View {
    TestPresenter presenter = new TestPresenter();
    LinearLayout tryAgainLayout;
    ProgressBar progressBarLayout;
    TextView toolbarTitle;
    ViewPager viewPager;
    TabLayout tabLayout;
    Toolbar toolbar;
    BaseModuleAdaptor baseAdaptor;
    boolean shouldRefresh = false;
    boolean canChangeTime = false;
    TextView walletAmountTextView;
    public TextView walletTimeTextView;
    LinearLayout baseWalletLayout;
    public ImageView walletImageView;
    boolean onSaveInstanceCalled = false;
    boolean otherTest = false;
    MockDataModel mockData = null;
    OtherTestDataModel otherTestDataModel = null;
    boolean clearFlag = true;

    @Override
    @RequiresApi(api=19)
    protected void initializeDagger() {
        this.tryAgainLayout = (LinearLayout)this.findViewById(R.id.try_again_layer);
        this.progressBarLayout = (ProgressBar)this.findViewById(R.id.progressbar_layer);
        this.toolbarTitle = (TextView)this.findViewById(R.id.toolbar_txt);
        this.viewPager = (ViewPager)this.findViewById(R.id.viewpager);
        this.tabLayout = (TabLayout)this.findViewById(R.id.tabs);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.walletAmountTextView = (TextView)this.findViewById(R.id.wallet_amount_text_view);
        this.walletTimeTextView = (TextView)this.findViewById(R.id.wallet_time_text_view);
        this.baseWalletLayout = (LinearLayout)this.findViewById(R.id.base_wallet_layout);
        this.walletImageView = (ImageView)this.findViewById(R.id.wallet_icon);
        this.toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.setBackEnabled(true);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MockTestActivity.this.backPressHandling();
            }
        });
        if (Build.VERSION.SDK_INT >= 24) {
            this.toolbarTitle.setText((CharSequence)Html.fromHtml((String)Objects.requireNonNull(this.getIntent().getExtras()).getString("com.title.bundle.language"), (int)0));
        } else {
            this.toolbarTitle.setText((CharSequence)Html.fromHtml((String)Objects.requireNonNull(this.getIntent().getExtras()).getString("com.title.bundle.language")));
        }
        this.baseWalletLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (LargeDataHandler.getInstance().getWalletUrl() != null) {
                    MockTestActivity.this.startActivity(new Intent(MockTestActivity.this.getApplicationContext(), TestUpgradeActivity.class).putExtra("action_header", "Plans").putExtra(Constants.PAYMENT_TYPE, LargeDataHandler.getInstance().getWalletUrl()));
                } else {
                    MockTestActivity.this.startActivity(new Intent(MockTestActivity.this.getApplicationContext(), TestUpgradeActivity.class).putExtra("action_header", "Plans").putExtra(Constants.PAYMENT_TYPE, Constants.BASE_PLAN_WALLET_URL));
                }
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    protected void initializePresenter() {
        block21: {
            ((BaseActivity)this).presenter = this.presenter;
            this.presenter.setView(this);
            if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_MOCK_TEST_TYPE) && this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE).equals("mock_notification")) {
                this.clearFlag = false;
                MainEventBus.getInstance().post((Object)new ClearSession());
                if (this.presenter != null) {
                    this.showProgressDialog(this.getString(R.string.str_please_wait));
                    this.presenter.callMockTestInfo(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL));
                }
            } else if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_OTHER_TEST_KEY)) {
                if (LargeDataHandler.getInstance().getCacheOtherTest(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE)) != null) {
                    OtherTestDataModel otherTestDataModel = (OtherTestDataModel)LargeDataHandler.getInstance().getCacheOtherTest(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE));
                    LargeDataHandler.getInstance().setOtherTestModel(otherTestDataModel);
                    this.otherTest = true;
                    this.baseAdaptor = new BaseModuleAdaptor(this.getSupportFragmentManager(), otherTestDataModel);
                    this.viewPager.setAdapter((PagerAdapter)this.baseAdaptor);
                    if (this.tabLayout != null) {
                        this.tabLayout.setupWithViewPager(this.viewPager, false);
                        BasicConfig.getInstance().apply((ViewGroup)this.tabLayout.getChildAt(0), "fonts/SF-UI-Display_Heavy_Cyrillic.otf", this.getApplicationContext());
                    }
                    if (this.getIntent().getExtras().containsKey("banner_name") && !this.onSaveInstanceCalled) {
                        try {
                            int current = this.currentObjectTab(this.getIntent().getExtras().getString("banner_name"), otherTestDataModel.examsList);
                            if (current != -1) {
                                this.viewPager.setCurrentItem(current, false);
                                break block21;
                            }
                            this.viewPager.setCurrentItem(0, false);
                        }
                        catch (Exception e) {
                            Log.d((String)"catch", (String)"at catch");
                        }
                    }
                } else {
                    this.showProgressDialog(this.getString(R.string.str_please_wait));
                    if (this.presenter != null) {
                        this.presenter.callOtherTestInfo(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL));
                    }
                }
            } else if (LargeDataHandler.getInstance().getCacheOtherTest("mock_" + this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE)) != null) {
                this.baseAdaptor = new BaseModuleAdaptor(this.getSupportFragmentManager(), (MockDataModel)LargeDataHandler.getInstance().getCacheOtherTest("mock_" + this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE)));
                this.viewPager.setAdapter((PagerAdapter)this.baseAdaptor);
                if (this.tabLayout != null) {
                    this.tabLayout.setupWithViewPager(this.viewPager, false);
                    BasicConfig.getInstance().apply((ViewGroup)this.tabLayout.getChildAt(0), "fonts/SF-UI-Display_Heavy_Cyrillic.otf", this.getApplicationContext());
                }
                if (this.getIntent().getExtras().containsKey("banner_name")) {
                    try {
                        if (this.onSaveInstanceCalled) break block21;
                        int current = this.currentTab(this.getIntent().getExtras().getString("banner_name"), ((MockDataModel)LargeDataHandler.getInstance().getCacheOtherTest((String)new StringBuilder().append((String)"mock_").append((String)this.getIntent().getExtras().getString((String)Constants.BUNDLE_KEY_MOCK_TEST_TYPE)).toString())).examsList);
                        if (current != -1) {
                            this.viewPager.setCurrentItem(current, false);
                            break block21;
                        }
                        this.viewPager.setCurrentItem(0, false);
                    }
                    catch (Exception e) {
                        Log.d((String)"catch", (String)"at catch");
                    }
                }
            } else if (this.presenter != null) {
                this.showProgressDialog(this.getString(R.string.str_please_wait));
                this.presenter.callMockTestInfo(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL));
            }
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_baselayout;
    }

    @RequiresApi(api=19)
    public void onSuccess(Object responseModel) {
        this.progressBarLayout.setVisibility(8);
        this.tryAgainLayout.setVisibility(8);
        this.hideProgressDialog();
        if (responseModel != null && responseModel instanceof MockDataModel) {
            String title = null;
            try {
                if (this.mockData != null) {
                    title = this.mockData.examsList.get(this.viewPager.getCurrentItem()).get(0);
                }
            }
            catch (Exception e) {
                Log.d((String)"catch", (String)"at catch");
            }
            this.mockData = (MockDataModel)responseModel;
            LargeDataHandler.getInstance().setCacheOtherTest("mock_" + Objects.requireNonNull(this.getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE), this.mockData);
            if (this.shouldRefresh) {
                LargeDataHandler.getInstance().clearMockData();
            }
            this.baseAdaptor = new BaseModuleAdaptor(this.getSupportFragmentManager(), this.mockData);
            this.viewPager.setAdapter((PagerAdapter)this.baseAdaptor);
            if (this.tabLayout != null) {
                this.tabLayout.setupWithViewPager(this.viewPager, false);
                if (this.shouldRefresh || this.getIntent().getExtras().containsKey("banner_name")) {
                    try {
                        int current = -1;
                        if (this.shouldRefresh) {
                            current = this.currentTab(title, this.mockData.examsList);
                            if (current != -1) {
                                this.viewPager.setCurrentItem(current, false);
                            } else {
                                this.viewPager.setCurrentItem(0, false);
                            }
                        } else if (this.getIntent().getExtras().containsKey("banner_name") && !this.onSaveInstanceCalled) {
                            current = this.currentTab(this.getIntent().getExtras().getString("banner_name"), this.mockData.examsList);
                            if (current != -1) {
                                this.viewPager.setCurrentItem(current, false);
                            } else {
                                this.viewPager.setCurrentItem(0, false);
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.d((String)"catch", (String)"at catch");
                    }
                }
                BasicConfig.getInstance().apply((ViewGroup)this.tabLayout.getChildAt(0), "fonts/SF-UI-Display_Heavy_Cyrillic.otf", this.getApplicationContext());
            }
        }
        this.shouldRefresh = false;
    }

    @Override
    public void onFailed() {
        this.hideProgressDialog();
        this.shouldRefresh = false;
        this.progressBarLayout.setVisibility(8);
        if (this.viewPager.getChildCount() == 0) {
            this.tryAgainLayout.setVisibility(0);
        } else {
            this.tryAgainLayout.setVisibility(8);
        }
    }

    public void onSuccess(List responseModel) {
    }

    @Override
    public void onFailed(String message) {
    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onSuccess(String response) {
    }

    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {
    }

    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_refresh, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_refresh) {
            this.shouldRefresh = true;
            this.tryAgainLayout.setVisibility(8);
            if (this.presenter != null) {
                this.showProgressDialog(this.getString(R.string.str_please_wait));
                if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_OTHER_TEST_KEY)) {
                    this.presenter.callOtherTestInfo(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL));
                } else {
                    this.presenter.callMockTestInfo(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL));
                }
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onResume() {
        super.onResume();
        try {
            MainEventBus.getInstance().register((Object)this);
        }
        catch (Exception e) {
            Log.d((String)"catch", (String)"at catch");
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.unSubscribe();
            LargeDataHandler.getInstance().clearOtherTestInfo();
        }
        try {
            MainEventBus.getInstance().unregister((Object)this);
        }
        catch (Exception e) {
            Log.d((String)"catch", (String)"at catch");
        }
    }

    @Subscribe
    @RequiresApi(api=19)
    public void getTestSubmitStatus(TestStatusEventModel statusEventModel) {
        if (Objects.requireNonNull(this.getIntent().getExtras()).containsKey(Constants.BUNDLE_KEY_OTHER_TEST_KEY) && statusEventModel.refreshWholeTest) {
            if (this.presenter != null) {
                this.presenter.callOtherTestInfo(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL));
            }
            MainEventBus.getInstance().post((Object)new UpdateTestCount());
        }
    }

    @Subscribe
    public void onSessionOut(SessionOut sessionOut) {
        this.finish();
    }

    @Subscribe
    public void onClearFlag(ClearSession flag) {
        if (this.clearFlag) {
            this.finish();
        }
        this.clearFlag = false;
    }

    @Subscribe
    public void onRefresh(RefreshTestInfo refresh) {
        if (this.otherTest && this.presenter != null) {
            this.shouldRefresh = false;
            if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_OTHER_TEST_KEY)) {
                this.presenter.callOtherTestInfo(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL));
            }
        }
    }

    @Subscribe
    public void onLiveTimeRunning(TimeInfo time) {
        if (this.canChangeTime) {
            if (time.time.equals("00:00:00")) {
                this.baseWalletLayout.setVisibility(8);
            }
            this.walletTimeTextView.setText((CharSequence)time.time);
        }
    }

    @Subscribe
    public void onWalletVisible(WalletVisibility info) {
        if (this.baseWalletLayout != null) {
            this.canChangeTime = true;
            this.baseWalletLayout.setVisibility(0);
            this.walletAmountTextView.setText((CharSequence)info.amout);
            this.walletTimeTextView.setText((CharSequence)info.time);
            Glide.with((FragmentActivity)this).load(((App)this.getApplicationContext()).getWalletIcon()).error(R.drawable.ic_wallet).into(this.walletImageView);
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putBoolean("savedData", true);
        super.onSaveInstanceState(savedInstanceState);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null && savedInstanceState.containsKey("savedData")) {
            this.onSaveInstanceCalled = savedInstanceState.getBoolean("savedData");
        }
    }

    public int currentTab(String examName, ArrayList<ArrayList<String>> examsList) {
        try {
            if (examName != null) {
                int index = -1;
                for (int i = 0; i < examsList.size(); ++i) {
                    if (!examsList.get(i).get(0).equalsIgnoreCase(examName)) continue;
                    index = i;
                    break;
                }
                return index;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int currentObjectTab(String examName, ArrayList<Object> examsList) {
        try {
            if (examName != null) {
                int index = -1;
                for (int i = 0; i < examsList.size(); i += 2) {
                    if (!((String)examsList.get(i)).equalsIgnoreCase(examName)) continue;
                    index = i / 2;
                    break;
                }
                return index;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey("from_notification")) {
            this.startActivity(new Intent(this.getApplicationContext(), HomeActivity.class));
            this.finish();
        } else {
            this.backPressHandling();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.startActivity(intent);
        this.finish();
    }

    public void backPressHandling() {
        try {
            if (!this.isTaskRoot()) {
                this.finish();
            } else if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey("com.from")) {
                this.startActivity(new Intent(this.getApplicationContext(), HomeActivity.class));
                this.finish();
            } else {
                this.finish();
            }
        }
        catch (Exception e) {
            this.finish();
        }
    }
}

