/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.os.Bundle;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.ViewGroup;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.ReCheckWallet;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.WalletPlanInfo;
import in.oliveboard.sdk.ui.adapters.PlanViewpagerAdaptor;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.onDialogUtilCalled;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class TestUpgradeActivity
extends BaseActivity
implements CommonContract.View,
onDialogUtilCalled {
    Toolbar toolbar;
    ViewPager viewPager;
    TabLayout tabs;
    TestPresenter presenter = new TestPresenter();

    @Override
    protected void initializeDagger() {
        App app = (App)this.getApplicationContext();
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.viewPager = (ViewPager)this.findViewById(R.id.upgrade_viewpager);
        this.tabs = (TabLayout)this.findViewById(R.id.upgrade_tabs);
        this.toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.setBackEnabled(true);
        try {
            if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey("spec_name")) {
                this.setTitle(this.getIntent().getExtras().getString("spec_name"));
            } else if (((App)this.getApplicationContext()).getLang().equals("hi")) {
                this.setTitle(R.string.nav_store_txt_hindi);
            } else {
                this.setTitle(R.string.nav_store_txt);
            }
        }
        catch (Exception e) {
            if (((App)this.getApplicationContext()).getLang().equals("hi")) {
                this.setTitle(R.string.nav_store_txt_hindi);
            }
            this.setTitle(R.string.nav_store_txt);
        }
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    protected void initializePresenter() {
        ((BaseActivity)this).presenter = this.presenter;
        this.presenter.setView(this);
        if (this.getIntent().getExtras().containsKey(Constants.PAYMENT_TYPE)) {
            this.showProgressDialog(this.getString(R.string.str_please_wait));
            if (this.presenter != null) {
                this.presenter.callWalletPlan(this.getIntent().getExtras().getString(Constants.PAYMENT_TYPE));
            }
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_upgrade;
    }

    public void onSuccess(Object responseModel) {
        if (!this.isFinishing()) {
            this.hideProgressDialog();
            if (responseModel != null && responseModel instanceof WalletPlanInfo) {
                this.viewPager.setAdapter((PagerAdapter)new PlanViewpagerAdaptor(this.getSupportFragmentManager(), (WalletPlanInfo)responseModel));
                this.tabs.setupWithViewPager(this.viewPager);
                BasicConfig.getInstance().apply((ViewGroup)this.tabs.getChildAt(0), "fonts/SF-UI-Display_Heavy_Cyrillic.otf", this.getApplicationContext());
            }
        }
    }

    @Override
    public void onFailed() {
    }

    public void onSuccess(List responseModel) {
    }

    @Override
    public void onFailed(String message) {
        this.hideProgressDialog();
        if (this.viewPager != null && this.viewPager.getChildCount() == 0 && !this.isFinishing()) {
            DialogUtils.getInstance().singleDialog(this, "check the network status and try again", "No Connectivity", "Ok", this);
        }
    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onSuccess(String response) {
    }

    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {
    }

    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {
    }

    @Override
    public void onOptionDialogSelected(int position) {
    }

    @Override
    public void onAutoDialogSelected() {
    }

    @Override
    public void onSubmitDialogSelected() {
    }

    @Override
    public void onExitApp() {
        this.finish();
    }

    @Override
    public void onExitWithoutPause() {
    }

    @Override
    public void onTryAgain() {
    }

    @Override
    public void onPauseTest(boolean value) {
    }

    @Override
    public void startTest(boolean value) {
    }

    @Override
    public void retyPermission() {
    }

    @Override
    public void gotoPurchase() {
    }

    @Override
    public void noPhoneAction() {
    }

    @Override
    public void openPermissionSetting() {
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MainEventBus.getInstance().post((Object)new ReCheckWallet());
    }
}

