package in.oliveboard.sdk.ui.fragments;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.RequiresApi;
import android.support.v4.view.ViewPager;
import android.util.Log;

import java.util.ArrayList;
import java.util.Objects;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.adapters.QuestionPageAdaptor;
import in.oliveboard.sdk.ui.base.BaseFragment;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.TestDataChangeListener;
import in.oliveboard.sdk.views.LoopViewPager;

public class TestModuleViewPagerFragment extends BaseFragment {
    LoopViewPager mLoopViewPager;
    TestDataChangeListener onTestDataChangeListener;
    int currentTotalQuestion = 1;

    @Override
    protected void initializeDagger() {

    }

    @Override
    protected void initializePresenter() {

    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void initializeActivity() {

        mLoopViewPager = Objects.requireNonNull(getView()).findViewById(R.id.pager);

        if (((App) Objects.requireNonNull(getActivity()).getApplicationContext()).getCurrentQuestionInfo() != null) {
                currentTotalQuestion = ((App) getActivity().getApplicationContext()).getCurrentQuestionInfo().size();
            }

            if (mLoopViewPager != null) {
                mLoopViewPager.setAdapter(new QuestionPageAdaptor(getChildFragmentManager(), getActivity(),false));
            }

        assert getArguments() != null;
        if (getArguments().getInt(Constants.INDEX) > 0) {
                if (mLoopViewPager != null) {
                    mLoopViewPager.setCurrentItem(getArguments().getInt(Constants.INDEX), false);
                }

            }
            if (((App) getActivity().getApplicationContext()).getCurrentQuestionInfo().size() > 0) {
                if (onTestDataChangeListener != null) {
                    onTestDataChangeListener.onLangaugeSwitchChange(((ArrayList<String>) ((App) getActivity().getApplicationContext()).getCurrentQuestionInfo().get(getArguments().getInt(Constants.INDEX)).getTestInfo().get(1)).size() > 1);
                    onTestDataChangeListener.onChangeQuestion(((App) getActivity().getApplicationContext()).getCurrentQuestionInfo().get(getArguments().getInt(Constants.INDEX)).getKey());
                }
            }


        mLoopViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                if(getArguments().getBoolean("type_qk"))
                {
                    Log.d("inside","yes");
                }
                else {
                    if (onTestDataChangeListener != null) {

                        onTestDataChangeListener.onLangaugeSwitchChange(((ArrayList<String>) ((App) getActivity().getApplicationContext()).getCurrentQuestionInfo().get(position).getTestInfo().get(1)).size() > 1 ? true : false);
                        onTestDataChangeListener.onChangeQuestion(((App) getActivity().getApplicationContext()).getCurrentQuestionInfo().get(position).getKey());
                    }
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

        assert getArguments() != null;
        if(getArguments().getBoolean("type_qk"))
        {

            Log.d("inside","yes");
        }
        else {
            if (((App) Objects.requireNonNull(getActivity()).getApplicationContext()).getSwitchToQuestion() > 0) {
                if (mLoopViewPager != null) {
                    mLoopViewPager.setCurrentItem(((App) getActivity().getApplicationContext()).getSwitchToQuestion(), false);
                    ((App) getActivity().getApplicationContext()).switchToPauseQuestion(0);
                }
            }
        }

    }

//    public static TestModuleViewPagerFragment setInstance(int position) {
//        TestModuleViewPagerFragment instance = new TestModuleViewPagerFragment();
//        Bundle bundleValue = new Bundle();
//        bundleValue.putInt(Constants.INDEX, position);
////        bundleValue.putInt("total",total);
//        instance.setArguments(bundleValue);
//
//        return instance;
//    }

    public static TestModuleViewPagerFragment setInstance(int position,boolean type) {
        TestModuleViewPagerFragment instance = new TestModuleViewPagerFragment();
        Bundle bundleValue = new Bundle();
        bundleValue.putInt(Constants.INDEX, position);
        bundleValue.putBoolean("type_qk",type);
        instance.setArguments(bundleValue);

        return instance;
    }


    public void changePosition(int position) {
        if (mLoopViewPager != null) {
            mLoopViewPager.setCurrentItem(position, false);
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        assert getArguments() != null;
        if (!getArguments().getBoolean("type_qk"))
        {
            onTestDataChangeListener = (TestDataChangeListener) context;
    }

    }

    @Override
    public int getLayoutId() {
        return R.layout.fragment_infinate_pager;
    }

    public void nextQuestion(final int position) {
        if (mLoopViewPager != null) {
//            Log.d("check_production","my pos"+position+"<<<<"+currentTotalQuestion);
//            if(mLoopViewPager.getChildCount())
            try {


                if (currentTotalQuestion > 1) {
                    new Handler().postDelayed(new Runnable() {
                        @RequiresApi(api = Build.VERSION_CODES.KITKAT)
                        @Override
                        public void run() {
                            if (((App) Objects.requireNonNull(getActivity()).getApplicationContext()).getCurrentQuestionInfo() != null && (mLoopViewPager.getCurrentItem() + 1) == currentTotalQuestion) {

                                mLoopViewPager.setCurrentItem(0, false);

                            } else {
                                mLoopViewPager.setCurrentItem((mLoopViewPager.getCurrentItem() + 1), true);
                            }
                        }
                    },250);
                }
            } catch (Exception e) {
                    Log.d("catch","cactch");
            }
        }
    }
}
