package in.oliveboard.sdk.ui.fragments;

import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;


import java.util.Objects;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.adapters.SummeryAdaptor;
import in.oliveboard.sdk.ui.base.BaseFragment;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.LargeDataHandler;

public class SolutionDetailFragment extends BaseFragment {
    public RecyclerView summeryRecyclerView;

    @Override
    protected void initializeDagger() {

    }

    @Override
    protected void initializePresenter() {

    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void initializeActivity() {
        summeryRecyclerView = Objects.requireNonNull(getView()).findViewById(R.id.recycler_view);
        summeryRecyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
        summeryRecyclerView.setAdapter(new SummeryAdaptor(LargeDataHandler.getInstance().getSummaryData()));
       // LogEvents.getInstance().passEvents(getActivity(),"Detailed Analysis Screen","view_page");

    }

    @Override
    public int getLayoutId() {
        return R.layout.fragment_recyler;
    }

    public static SolutionDetailFragment newInstance() {
         return new SolutionDetailFragment();
    }
}
