package in.oliveboard.sdk.ui.adapters;

import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;

import in.oliveboard.sdk.ui.fragments.SolutionDetailFragment;
import in.oliveboard.sdk.ui.fragments.SolutionWebDetailFragment;


public class SummaryFragmentAdapter extends FragmentStatePagerAdapter {
    boolean haveDetailSummary;

    public SummaryFragmentAdapter(FragmentManager fm, boolean haveDetailSummary) {
        super(fm);
        this.haveDetailSummary = haveDetailSummary;
    }

    @Override
    public Fragment getItem(int position) {
        if (position == 0) {
            return SolutionDetailFragment.newInstance();
        } else {
            return SolutionWebDetailFragment.newInstance();

        }

    }

    @Override
    public int getCount() {
        if (haveDetailSummary) {
            return 2;
        } else {
            return 1;
        }
    }

    @Override
    public CharSequence getPageTitle(int position) {

        if (position == 0) {
            return "Summary";
        } else {
            return "Detailed Analysis";
        }
    }
    @Override
    public int getItemPosition(Object object){
        return PagerAdapter.POSITION_NONE;
    }
    @Override
    public Parcelable saveState()
    {
        return null;
    }
}
