package in.oliveboard.sdk.ui;

import android.content.Intent;
import android.os.Bundle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;


import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;


public class TestSectionActivity extends BaseActivity implements CommonContract.View {
    TestPresenter presenter = new TestPresenter();

    @Override
    protected void initializeDagger() {
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);

          showProgressDialog(getString(R.string.str_loading_test));
//        showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_loading_test_hindi):getString(R.string.str_loading_test));

        //LogEvents.getInstance().passEvents(getApplicationContext(),"TestNextSectionScreen","view_page");
        if(presenter!=null) {
            ((App) getApplicationContext()).clearAllData();
            presenter.callNativeTestApp(getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL));
        }


    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_solution_infinate;
    }

    @Override
    public void onSuccess(Object responseModel) {

    }

    @Override
    public void onFailed() {

    }

    @Override
    public void onSuccess(List responseModel) {

    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onSuccess(String response) {

    }

    @Override
    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {

    }

    @Override
    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {
        hideProgressDialog();
        if (status) {
            if (response != null) {

                ((App) getApplicationContext()).setQuestionInfo(response);
                ((App) getApplicationContext()).setQuestionSet(questionSet);
                ((App) getApplicationContext()).setQuestionAnswerInfo(restructuredModelList);
//                Log.d("chekkoooomui","data setting.....");
                if (getIntent().getExtras() != null && getIntent().getExtras().getBoolean(Constants.BUNDLE_KEY_EXAM_URL)) {
                    startActivity(new Intent(getApplicationContext(), TestModuleActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME,getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra(Constants.BASE_BUNDLE_URL, getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL)).putExtra(Constants.IS_MOCK, true).putExtra(Constants.PART_TEST,true).putExtra(Constants.BUNDLE_SHOULD_CHANGE,true));
                    finish();
                } else {
                    startActivity(new Intent(getApplicationContext(), TestModuleActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME,getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra(Constants.BASE_BUNDLE_URL, getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL)).putExtra(Constants.IS_MOCK, false).putExtra(Constants.PART_TEST,true).putExtra(Constants.BUNDLE_SHOULD_CHANGE,true));
                    finish();
                }
            }
        } else {
//            Toast.makeText(getActivity(), "try again", Toast.LENGTH_LONG).show();
            finish();

        }
    }
    @Override
    public void onFailed(String message) {

    }
}
