package in.oliveboard.sdk.presenter.usecase;


import java.util.Map;
import in.oliveboard.sdk.communication.HTTPAsyncTaskAuth;
import in.oliveboard.sdk.communication.HTTPAsyncTaskForgotPassword;
import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.base.UseCase;
import in.oliveboard.sdk.utils.Constants;


public class AuthUseCase implements UseCase.AuthUseCase {

    @Override
    public void getSignUpResponse(BaseCallback callback, Map<String, String> userInfo) {
        new HTTPAsyncTaskAuth(Constants.BASE_URL+"sdkregister.cgi",userInfo,callback).execute();
    }

    @Override
    public void getLoginResponse(BaseCallback callback, Map<String, String> userInfo) {
        new HTTPAsyncTaskAuth(Constants.BASE_URL+"sdklogin.cgi",userInfo,callback).execute();
    }

    @Override
    public void getChangePasswordResponse(BaseCallback callback, Map<String, String> userInfo) {
        new HTTPAsyncTaskForgotPassword(Constants.BASE_URL+"forgotpass.cgi",userInfo,callback).execute();

    }
}
