/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Build;
import java.util.Locale;

public class LocaleContextWrapper
extends ContextWrapper {
    private static String mLocaleCode = null;

    public LocaleContextWrapper(Context base) {
        super(base);
    }

    public static ContextWrapper wrap(Context context, String language) {
        Configuration config = context.getResources().getConfiguration();
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleContextWrapper.setSystemLocale(config, locale);
        } else {
            LocaleContextWrapper.setSystemLocaleLegacy(config, locale);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            context = context.createConfigurationContext(config);
        } else {
            context.getResources().updateConfiguration(config, context.getResources().getDisplayMetrics());
        }
        return new LocaleContextWrapper(context);
    }

    public static Locale getSystemLocaleLegacy(Configuration config) {
        return config.locale;
    }

    @TargetApi(value=24)
    public static Locale getSystemLocale(Configuration config) {
        return config.getLocales().get(0);
    }

    public static void setSystemLocaleLegacy(Configuration config, Locale locale) {
        config.locale = locale;
    }

    @TargetApi(value=24)
    public static void setSystemLocale(Configuration config, Locale locale) {
        config.setLocale(locale);
    }

    public static void setLocaleCode(String localeCode) {
        mLocaleCode = localeCode;
    }

    public static String getLocalCode() {
        return mLocaleCode;
    }
}

