/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.CardView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.widget.Toast;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestDialogInfo;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.ui.adapters.QuickActionAdaptor;
import in.oliveboard.sdk.utils.BaseSharedPreferences;
import in.oliveboard.sdk.utils.FilterQuestions;
import in.oliveboard.sdk.utils.RecyclerItemClickListener;
import in.oliveboard.sdk.utils.onDialogOptionCalled;
import in.oliveboard.sdk.utils.onDialogUtilCalled;
import java.util.ArrayList;
import java.util.TreeMap;

public class DialogUtils {
    public static DialogUtils dialogUtils;
    boolean isStartTest;
    AlertDialog alertD = null;

    public static synchronized DialogUtils getInstance() {
        if (dialogUtils == null) {
            dialogUtils = new DialogUtils();
        }
        return dialogUtils;
    }

    public void selfStopDialog(AppCompatActivity context, onDialogUtilCalled dialogUtilCalled, boolean isNextTest) {
        View promptView = context.getLayoutInflater().inflate(R.layout.auto_submit_dialog_olivesdk, null);
        this.alertD = new AlertDialog.Builder((Context)context).create();
        this.alertD.setCancelable(false);
        this.alertD.setCanceledOnTouchOutside(false);
        Button mSubmit = (Button)promptView.findViewById(R.id.auto_submit_test);
        this.alertD.setView(promptView);
        this.alertD.show();
        mSubmit.setText((CharSequence)"Please wait...");
        mSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }

    public void closeSelfDialog() {
        try {
            if (this.alertD != null) {
                this.alertD.dismiss();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startTestDialog(AppCompatActivity context, TestResponseModel testInfo, final onDialogUtilCalled dialogUtilCalled, boolean isResume) {
        this.isStartTest = false;
        View promptView = context.getLayoutInflater().inflate(R.layout.testapp_custom_dialog_olivesdk, null);
        final AlertDialog alertD = new AlertDialog.Builder((Context)context).create();
        alertD.setView(promptView);
        TextView testNameTextView = (TextView)promptView.findViewById(R.id.start_test_title);
        TextView timeStringTextView = (TextView)promptView.findViewById(R.id.start_test_duration);
        TextView questionTextView = (TextView)promptView.findViewById(R.id.start_test_question_count);
        TextView marksCorrectTextView = (TextView)promptView.findViewById(R.id.start_test_correct_marks);
        TextView correctTextView = (TextView)promptView.findViewById(R.id.start_test_correct);
        TextView wrongTextView = (TextView)promptView.findViewById(R.id.start_test_wrong);
        TextView marksWrongTextView = (TextView)promptView.findViewById(R.id.start_tset_worng_marks);
        Button startTestButton = (Button)promptView.findViewById(R.id.start_test);
        if (isResume) {
            startTestButton.setText((CharSequence)"RESUME TEST");
        }
        alertD.show();
        testNameTextView.setText((CharSequence)testInfo.questionId);
        questionTextView.setText((CharSequence)("" + testInfo.settings.numberOfQuestion));
        timeStringTextView.setText((CharSequence)testInfo.settings.totalTimeString);
        if (testInfo.settings.cwmap != null && testInfo.settings.cwmap.size() >= 2) {
            marksCorrectTextView.setText((CharSequence)testInfo.settings.cwmap.get(0));
            marksWrongTextView.setText((CharSequence)testInfo.settings.cwmap.get(1));
        } else {
            marksCorrectTextView.setVisibility(8);
            marksWrongTextView.setVisibility(8);
            correctTextView.setVisibility(8);
            wrongTextView.setVisibility(8);
        }
        alertD.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                if (!DialogUtils.this.isStartTest && dialogUtilCalled != null) {
                    dialogUtilCalled.startTest(false);
                }
            }
        });
        startTestButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogUtils.this.isStartTest = true;
                alertD.dismiss();
                if (dialogUtilCalled != null) {
                    dialogUtilCalled.startTest(true);
                }
            }
        });
    }

    public void exitDialog(AppCompatActivity context, final onDialogUtilCalled onDialogUtilCalled2) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        View promptView = layoutInflater.inflate(R.layout.dialog_exit_test_olivesdk, null);
        final AlertDialog alertD = new AlertDialog.Builder((Context)context).create();
        alertD.setCancelable(false);
        Button btnAdd1 = (Button)promptView.findViewById(R.id.okBtn);
        Button btnAdd2 = (Button)promptView.findViewById(R.id.cancelBtn);
        btnAdd1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertD.dismiss();
                if (onDialogUtilCalled2 != null) {
                    onDialogUtilCalled2.onExitApp();
                }
            }
        });
        btnAdd2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertD.cancel();
            }
        });
        alertD.setView(promptView);
        alertD.show();
    }

    public void displayPopupWindow(View anchorView, AppCompatActivity context, TreeMap<Integer, SectionKeyValue> questionSet, final onDialogUtilCalled dialogUtilCalled, String selectedOption) {
        final PopupWindow popup = new PopupWindow((Context)context);
        View layout2 = context.getLayoutInflater().inflate(R.layout.quickaction_dialog_olivesdk, null);
        RecyclerView list = (RecyclerView)layout2.findViewById(R.id.recycler_view);
        popup.setContentView(layout2);
        popup.setHeight(-2);
        popup.setWidth(-2);
        popup.setOutsideTouchable(true);
        popup.setFocusable(true);
        popup.setBackgroundDrawable((Drawable)new BitmapDrawable());
        popup.showAsDropDown(anchorView);
        list.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)context));
        list.setAdapter((RecyclerView.Adapter)new QuickActionAdaptor((Context)context, questionSet, selectedOption));
        list.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerItemClickListener((Context)context, list, new RecyclerItemClickListener.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                popup.dismiss();
                if (dialogUtilCalled != null) {
                    dialogUtilCalled.onOptionDialogSelected(position);
                }
            }

            @Override
            public void onItemLongClick(View view, int position) {
            }
        }));
    }

    public void submitTestDialog(AppCompatActivity context, ArrayList<TestAppModel> questionAnswerInfo, final onDialogUtilCalled dialogUtilCalled, boolean isNextTest) {
        ArrayList<TestDialogInfo> summeryInfo = FilterQuestions.getInstance().getSummeryInfo(questionAnswerInfo);
        View promptView = context.getLayoutInflater().inflate(R.layout.test_submit_dialog_olivesdk, null);
        final AlertDialog alertD = new AlertDialog.Builder((Context)context).create();
        TextView mark = (TextView)promptView.findViewById(R.id.marked_count);
        TextView attempt = (TextView)promptView.findViewById(R.id.attempted_count);
        TextView unAttempt = (TextView)promptView.findViewById(R.id.un_attempted_count);
        Button mResume = (Button)promptView.findViewById(R.id.resume_test);
        Button mSubmit = (Button)promptView.findViewById(R.id.submit_test);
        alertD.setView(promptView);
        alertD.show();
        if (isNextTest) {
            mSubmit.setText((CharSequence)"Next Section");
        }
        unAttempt.setText((CharSequence)String.valueOf(summeryInfo.get(0).getUnattemped()));
        mark.setText((CharSequence)String.valueOf(summeryInfo.get(0).getFav()));
        attempt.setText((CharSequence)String.valueOf(summeryInfo.get(0).getAttempted()));
        mSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertD.cancel();
                if (dialogUtilCalled != null) {
                    dialogUtilCalled.onSubmitDialogSelected();
                }
            }
        });
        mResume.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertD.cancel();
            }
        });
    }

    public void gotoPurchaseDialog(Fragment context, final onDialogUtilCalled dialogUtilCalled) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context.getActivity());
        View promptView = layoutInflater.inflate(R.layout.upgrade_alert_dialog_olivesdk, null);
        final AlertDialog alertD = new AlertDialog.Builder((Context)context.getActivity()).create();
        alertD.setCancelable(true);
        Button btnAdd1 = (Button)promptView.findViewById(R.id.saveBtn);
        Button btnAdd2 = (Button)promptView.findViewById(R.id.cancelBtn);
        btnAdd1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertD.cancel();
                if (dialogUtilCalled != null) {
                    dialogUtilCalled.gotoPurchase();
                }
            }
        });
        btnAdd2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertD.cancel();
            }
        });
        alertD.setView(promptView);
        alertD.show();
    }

    public void tryAgainSubmit(AppCompatActivity context, final onDialogUtilCalled onDialogUtilCalled2) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        builder.setCancelable(false);
        builder.setTitle((CharSequence)"Try Again");
        builder.setMessage((CharSequence)"Submit test failed. Do you want to try again?");
        builder.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                if (onDialogUtilCalled2 != null) {
                    onDialogUtilCalled2.onTryAgain();
                }
            }
        });
        builder.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                if (onDialogUtilCalled2 != null) {
                    onDialogUtilCalled2.onExitWithoutPause();
                }
            }
        });
        builder.show();
    }

    public void pauseOrResumeTest(AppCompatActivity context, final onDialogUtilCalled onDialogUtilCalled2, String title, String message, String positiveButton, String cancel) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        builder.setTitle((CharSequence)title);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton((CharSequence)positiveButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                if (onDialogUtilCalled2 != null) {
                    onDialogUtilCalled2.onPauseTest(true);
                }
            }
        });
        builder.setNegativeButton((CharSequence)cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                if (onDialogUtilCalled2 != null) {
                    onDialogUtilCalled2.onPauseTest(false);
                }
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
        alertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                dialog.dismiss();
                if (onDialogUtilCalled2 != null) {
                    onDialogUtilCalled2.onPauseTest(false);
                }
            }
        });
    }

    public void displayInfoPopupWindow(String percentage, String level, View anchorView, Fragment context) {
        PopupWindow popup = new PopupWindow((Context)context.getActivity());
        View layout2 = context.getActivity().getLayoutInflater().inflate(R.layout.quickaction_solution_info_dialog_olivesdk, null);
        popup.setContentView(layout2);
        TextView percentageTextView = (TextView)layout2.findViewById(R.id.percentage_text_view);
        TextView levelTextView = (TextView)layout2.findViewById(R.id.level_text_view);
        levelTextView.setText((CharSequence)level);
        percentageTextView.setText((CharSequence)percentage);
        popup.setHeight(-2);
        popup.setWidth(-2);
        popup.setOutsideTouchable(true);
        popup.setFocusable(true);
        popup.setBackgroundDrawable((Drawable)new BitmapDrawable());
        popup.showAsDropDown(anchorView);
    }

    public void startSolutionSummeryDialog(AppCompatActivity context, final onDialogUtilCalled dialogUtilCalled, String totalTime, String totalQuestions, String testName, final boolean initialLoad, String totalMark, int correctAnswer, int wrongAnser, String accuracyString) {
        View promptView = context.getLayoutInflater().inflate(R.layout.test_summary_dialog_olivesdk, null);
        final AlertDialog alertD = new AlertDialog.Builder((Context)context).create();
        if (initialLoad) {
            alertD.setCancelable(false);
            alertD.setCanceledOnTouchOutside(false);
        }
        alertD.setView(promptView);
        TextView testNameTextView = (TextView)promptView.findViewById(R.id.test_name_txt);
        TextView timeStringTextView = (TextView)promptView.findViewById(R.id.test_time_txt);
        TextView questionTextView = (TextView)promptView.findViewById(R.id.test_questions_number_txt);
        ImageView closeTestButton = (ImageView)promptView.findViewById(R.id.dialog_close);
        TextView correctTextView = (TextView)promptView.findViewById(R.id.test_summary_right_count);
        TextView wrongTextView = (TextView)promptView.findViewById(R.id.test_summary_wrong_count);
        TextView totalTextView = (TextView)promptView.findViewById(R.id.test_summary_totalScore);
        TextView accurecyTextView = (TextView)promptView.findViewById(R.id.test_summary_accuracy_percentage);
        Button viewSolutionButton = (Button)promptView.findViewById(R.id.start_test_button_view);
        CardView startTestCard = (CardView)promptView.findViewById(R.id.start_test_card_view);
        correctTextView.setText((CharSequence)("" + correctAnswer));
        wrongTextView.setText((CharSequence)("" + wrongAnser));
        if (accuracyString.equals("0.00 % ")) {
            accurecyTextView.setText((CharSequence)"0 %");
        } else {
            accurecyTextView.setText((CharSequence)accuracyString);
        }
        totalTextView.setText((CharSequence)totalMark);
        if (totalTime != null) {
            timeStringTextView.setText((CharSequence)totalTime);
        }
        if (totalQuestions != null) {
            questionTextView.setText((CharSequence)totalQuestions);
        }
        if (testName != null) {
            testNameTextView.setText((CharSequence)testName);
        }
        if (!initialLoad) {
            viewSolutionButton.setText((CharSequence)context.getResources().getString(R.string.solution_text));
        }
        alertD.show();
        viewSolutionButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                alertD.dismiss();
            }
        });
        closeTestButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                alertD.dismiss();
                if (initialLoad && dialogUtilCalled != null) {
                    dialogUtilCalled.onExitApp();
                }
            }
        });
        startTestCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                alertD.dismiss();
            }
        });
    }

    public void singleDialog(AppCompatActivity context, String message, String title, String ok, final onDialogUtilCalled onDialogUtilCalled2) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        builder.setCancelable(false);
        builder.setTitle((CharSequence)title);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton((CharSequence)ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                if (onDialogUtilCalled2 != null) {
                    onDialogUtilCalled2.onExitApp();
                }
            }
        });
        builder.show();
    }

    public void multipleOptionFragmentDialog(FragmentActivity context, final onDialogOptionCalled onDialogUtilCalled2, String title, String message, String positiveMessage, String negativeMessage) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        builder.setCancelable(false);
        builder.setTitle((CharSequence)title);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton((CharSequence)positiveMessage, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                if (onDialogUtilCalled2 != null) {
                    onDialogUtilCalled2.onPositiveClick();
                }
            }
        });
        builder.setNegativeButton((CharSequence)negativeMessage, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                if (onDialogUtilCalled2 != null) {
                    onDialogUtilCalled2.onNegativeClick();
                }
            }
        });
        builder.show();
    }

    public void permissionAlerts(final AppCompatActivity context, final onDialogUtilCalled dialogUtilCalled, final BaseSharedPreferences baseSharedPreferences) {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder((Context)context);
        alertDialogBuilder.setTitle((CharSequence)"Permissions Required").setMessage((CharSequence)"Without this permission the app is unable to send you new test updates and other features. Are you sure to deny this permission?").setPositiveButton((CharSequence)"RE-TRY", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                dialogUtilCalled.retyPermission();
            }
        }).setNegativeButton((CharSequence)"I'M SURE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                DialogUtils.this.permissionPermanentDenyAlerts(context, dialogUtilCalled, false, "You have forcefully denied some of the required permissions\nIf it was by accident you can allow the permission again ", "Try again", baseSharedPreferences);
            }
        }).setCancelable(false).create().show();
    }

    public void permissionPermanentDenyAlerts(final AppCompatActivity context, final onDialogUtilCalled dialogUtilCalled, final boolean gotoSetting, String message, String positiveOption, final BaseSharedPreferences baseSharedPreferences) {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder((Context)context);
        alertDialogBuilder.setTitle((CharSequence)"Permissions Required").setMessage((CharSequence)message).setPositiveButton((CharSequence)positiveOption, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (gotoSetting) {
                    dialogUtilCalled.openPermissionSetting();
                } else {
                    dialogUtilCalled.retyPermission();
                }
            }
        }).setNegativeButton((CharSequence)"Don't show again", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Toast.makeText((Context)context, (CharSequence)"permisson not granded", (int)0).show();
                baseSharedPreferences.putData("PhonePermission", -1);
                baseSharedPreferences.putData("PhoneDeniedPermission", -1);
                dialogUtilCalled.noPhoneAction();
            }
        }).setCancelable(false).create().show();
    }
}

