/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.adapters.viewholder.MockDescHeaderViewHolder;
import in.oliveboard.sdk.ui.adapters.viewholder.MockTestListViewHolder;
import java.util.ArrayList;

public class MockTestListAdaptor
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    Context context;
    ArrayList<ArrayList<String>> mockTestModelList;
    String descriptionText;
    private static final int TYPE_HEADER = 0;
    private static final int TYPE_DATA = 1;

    public MockTestListAdaptor(Context context, ArrayList<ArrayList<String>> mockTestModelList, String descriptionText) {
        this.context = context;
        this.mockTestModelList = mockTestModelList;
        this.descriptionText = descriptionText;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.mock_desc_header_olivesdk, parent, false);
            return new MockDescHeaderViewHolder(itemView);
        }
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.mock_test_card_olivesdk, parent, false);
        return new MockTestListViewHolder(itemView);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder mainholder, int position) {
        if (mainholder instanceof MockTestListViewHolder) {
            MockTestListViewHolder holder = (MockTestListViewHolder)mainholder;
            int finalPosition = position;
            if (this.descriptionText != null) {
                finalPosition = position - 1;
            }
            holder.titleView.setText((CharSequence)this.mockTestModelList.get(finalPosition).get(1));
            if ("AV".equalsIgnoreCase(this.mockTestModelList.get(finalPosition).get(0))) {
                holder.imageView.setImageResource(R.drawable.icon_av);
                holder.imageView.setBackgroundColor(this.context.getResources().getColor(R.color.primary_color_dark));
                holder.testScore.setTextColor(this.context.getResources().getColor(R.color.view_hide_color));
                holder.testQuestions.setTextColor(this.context.getResources().getColor(R.color.view_hide_color));
                holder.testTime.setTextColor(this.context.getResources().getColor(R.color.view_hide_color));
                holder.testScore.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_graph_light, 0, 0, 0);
                holder.testQuestions.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_light, 0, 0, 0);
                holder.testTime.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_clock_light, 0, 0, 0);
                holder.testScore.setVisibility(0);
                holder.testScore.setText((CharSequence)this.mockTestModelList.get(finalPosition).get(2));
                holder.testQuestions.setVisibility(0);
                holder.wrong.setVisibility(4);
                holder.testTime.setVisibility(0);
                holder.testTime.setText((CharSequence)this.mockTestModelList.get(finalPosition).get(4));
                holder.testQuestions.setText((CharSequence)this.mockTestModelList.get(finalPosition).get(3));
                holder.mock_test_right_layout.setVisibility(0);
                holder.mock_test_reward_layout.setVisibility(0);
            } else if ("UP".equalsIgnoreCase(this.mockTestModelList.get(finalPosition).get(0))) {
                holder.imageView.setImageResource(R.drawable.icon_up);
                holder.imageView.setBackgroundColor(this.context.getResources().getColor(R.color.lock_red));
                holder.testScore.setVisibility(8);
                holder.wrong.setVisibility(8);
                holder.testQuestions.setVisibility(8);
                holder.testTime.setVisibility(8);
                holder.mock_test_right_layout.setVisibility(0);
                holder.mock_test_reward_layout.setVisibility(0);
            } else if ("CO".equalsIgnoreCase(this.mockTestModelList.get(finalPosition).get(0))) {
                holder.imageView.setImageResource(R.drawable.icon_co);
                holder.imageView.setBackgroundColor(this.context.getResources().getColor(R.color.co_green));
                holder.testScore.setTextColor(this.context.getResources().getColor(R.color.colorTextPrimary));
                holder.testQuestions.setTextColor(this.context.getResources().getColor(R.color.colorTextPrimary));
                holder.wrong.setTextColor(this.context.getResources().getColor(R.color.red));
                holder.testTime.setTextColor(this.context.getResources().getColor(R.color.colorTextPrimary));
                holder.testScore.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_graph_dark, 0, 0, 0);
                holder.testQuestions.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_dark, 0, 0, 0);
                holder.testTime.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_acc, 0, 0, 0);
                holder.testScore.setVisibility(0);
                holder.testScore.setText((CharSequence)this.mockTestModelList.get(finalPosition).get(2));
                holder.testQuestions.setVisibility(0);
                holder.wrong.setText((CharSequence)this.mockTestModelList.get(finalPosition).get(4));
                holder.wrong.setVisibility(0);
                holder.testTime.setVisibility(0);
                holder.testTime.setText((CharSequence)this.mockTestModelList.get(finalPosition).get(5));
                holder.testQuestions.setText((CharSequence)(this.mockTestModelList.get(finalPosition).get(3) + "/"));
                holder.mock_test_right_layout.setVisibility(0);
                holder.mock_test_reward_layout.setVisibility(0);
            } else if ("CS".equalsIgnoreCase(this.mockTestModelList.get(finalPosition).get(0))) {
                holder.imageView.setImageResource(R.drawable.icon_cs);
                holder.imageView.setBackgroundColor(this.context.getResources().getColor(R.color.windowBackground));
                holder.testScore.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
                holder.testScore.setTextColor(this.context.getResources().getColor(R.color.view_hide_color));
                holder.testScore.setVisibility(0);
                holder.testScore.setText((CharSequence)this.mockTestModelList.get(finalPosition).get(2));
                holder.testQuestions.setVisibility(4);
                holder.wrong.setVisibility(4);
                holder.testTime.setVisibility(4);
                holder.mock_test_right_layout.setVisibility(8);
                holder.mock_test_reward_layout.setVisibility(8);
            }
        } else if (mainholder instanceof MockDescHeaderViewHolder) {
            MockDescHeaderViewHolder holder = (MockDescHeaderViewHolder)mainholder;
            holder.titleView.setText((CharSequence)this.descriptionText);
        }
    }

    public int getItemCount() {
        if (this.descriptionText != null) {
            return this.mockTestModelList.size() + 1;
        }
        return this.mockTestModelList.size();
    }

    public int getItemViewType(int position) {
        if (this.descriptionText != null && position == 0) {
            return 0;
        }
        return 1;
    }

    public void onMockDescripionChange(String mockDescriptionText) {
        this.descriptionText = mockDescriptionText.replaceAll("\n", "\n\n");
    }
}

