/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.adapters;

import android.content.Context;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import in.oliveboard.sdk.R;
import java.util.ArrayList;

public class GridExamsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<ArrayList<String>> mExamsInfo;
    private Context mContext;
    private ItemClickListener itemClickListener;
    private int parentPosition;

    public GridExamsAdapter(Context context, ItemClickListener clickListener, int position, ArrayList<ArrayList<String>> examsInfo) {
        this.mContext = context;
        this.itemClickListener = clickListener;
        this.parentPosition = position;
        this.mExamsInfo = examsInfo;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_exams_olivesdk, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, final int position) {
        holder.examTitle.setText((CharSequence)this.mExamsInfo.get(position).get(0));
        holder.subTitles.setText((CharSequence)this.mExamsInfo.get(position).get(2));
        Glide.with((Context)this.mContext).load(this.mExamsInfo.get(position).get(1)).placeholder(R.drawable.ic_placeholder_square).into(holder.testImageView);
        holder.examsCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GridExamsAdapter.this.itemClickListener.onItemClick(position, GridExamsAdapter.this.parentPosition);
            }
        });
    }

    public int getItemCount() {
        return this.mExamsInfo.size();
    }

    public static interface ItemClickListener {
        public void onItemClick(int var1, int var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        TextView examTitle;
        TextView subTitles;
        ImageView testImageView;
        CardView examsCard;

        ViewHolder(View itemView) {
            super(itemView);
            this.examTitle = (TextView)itemView.findViewById(R.id.bind_exams_title);
            this.subTitles = (TextView)itemView.findViewById(R.id.bind_exams_msg);
            this.testImageView = (ImageView)itemView.findViewById(R.id.test_image_view);
            this.examsCard = (CardView)itemView.findViewById(R.id.bind_exams_card);
        }

        public void onClick(View view) {
        }
    }
}

