/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.presenter.usecase;

import android.content.Context;
import android.widget.Toast;
import com.google.gson.Gson;
import in.oliveboard.sdk.communication.HTTPAsyncTaskMockSectional;
import in.oliveboard.sdk.communication.HTTPAsyncTaskMockSingleTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskMockTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskNativeSolution;
import in.oliveboard.sdk.communication.HTTPAsyncTaskNativeTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskPauseModuleTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskPauseTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskSubmitTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskSummeryTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskWalletData;
import in.oliveboard.sdk.communication.HTTPAsyncTaskWalletInfo;
import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.base.UseCase;
import in.oliveboard.sdk.presenter.model.PauseTestData;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public class TestUseCase
implements UseCase.TestUseCase {
    private boolean checkInternet(BaseCallback callback, Context context) {
        if (Utils.isConnectionAvailable(context)) {
            return true;
        }
        Toast.makeText((Context)context, (CharSequence)"No internet connection", (int)0).show();
        callback.onFail();
        return false;
    }

    @Override
    public void getMockData(BaseCallback callback, String url, Context context) {
        if (this.checkInternet(callback, context)) {
            new HTTPAsyncTaskMockTest(url, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
        }
    }

    @Override
    public void getSingleTest(BaseCallback callback, String url, Context context) {
        if (this.checkInternet(callback, context)) {
            new HTTPAsyncTaskMockSingleTest(url, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
        }
    }

    @Override
    public void getNativeTest(BaseCallback callback, String url, Context context) {
        if (this.checkInternet(callback, context)) {
            new HTTPAsyncTaskNativeTest(url, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
        }
    }

    @Override
    public void getNativeSolution(BaseCallback callback, String url, Context context) {
        if (this.checkInternet(callback, context)) {
            new HTTPAsyncTaskNativeSolution(url, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
        }
    }

    @Override
    public void getSummeryTest(BaseCallback callback, String url, Context context) {
        if (this.checkInternet(callback, context)) {
            new HTTPAsyncTaskSummeryTest(url, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
        }
    }

    @Override
    public void getSubmitTest(BaseCallback callback, String url, Map<String, String> params, Context context) {
        if (this.checkInternet(callback, context)) {
            new HTTPAsyncTaskSubmitTest(url, params, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
        }
    }

    @Override
    public void getPauseTest(BaseCallback callback, String url, PauseTestData pauseData, String qpi, String userid, String ppid, Context context) {
        if (this.checkInternet(callback, context)) {
            if (ppid == null) {
                String data = new Gson().toJson((Object)pauseData);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("data", data);
                map.put("qpi", qpi);
                map.put("uid", userid);
                new HTTPAsyncTaskPauseTest(url, map, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
            } else {
                String data = new Gson().toJson((Object)pauseData);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("data", data);
                map.put("qpi", qpi);
                map.put("uid", userid);
                map.put("ppi", ppid);
                new HTTPAsyncTaskPauseModuleTest(url, map, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
            }
        }
    }

    @Override
    public void getMockSectionalInfo(BaseCallback callback, String url, Context context) {
        if (this.checkInternet(callback, context)) {
            new HTTPAsyncTaskMockSectional(url, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
        }
    }

    public void unSubscribe() {
    }

    @Override
    public void getWalletInfoData(BaseCallback callback, String url, Context context) {
        if (this.checkInternet(callback, context)) {
            new HTTPAsyncTaskWalletInfo(url, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
        }
    }

    @Override
    public void getWalletData(BaseCallback callback, String url, Context context) {
        if (this.checkInternet(callback, context)) {
            new HTTPAsyncTaskWalletData(url, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute(new String[0]);
        }
    }
}

