/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.communication;

import android.os.AsyncTask;
import com.google.gson.Gson;
import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.model.ForgotPasswordModel;
import in.oliveboard.sdk.utils.BaseSharedPreferences;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

public final class HTTPAsyncTaskForgotPassword
extends AsyncTask<String, Void, String> {
    String url;
    Map<String, String> postDataParams;
    BaseCallback callback;
    BaseSharedPreferences baseSharedPreferences;
    String cookieAuthtoken;
    String cookieVersion;
    String cookieDeviceid;

    public HTTPAsyncTaskForgotPassword(String url, Map<String, String> postDataParams, BaseCallback callback) {
        this.url = url;
        this.postDataParams = postDataParams;
        this.callback = callback;
    }

    protected String doInBackground(String ... urls) {
        try {
            return this.performPostCall(this.url, this.postDataParams);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void onPostExecute(String result) {
        ForgotPasswordModel forgotPasswordResponseModel = (ForgotPasswordModel)new Gson().fromJson(result, ForgotPasswordModel.class);
        if (forgotPasswordResponseModel != null && forgotPasswordResponseModel.resetKey.equals("1")) {
            this.callback.onLoginSuccess(forgotPasswordResponseModel.resetKey);
        } else {
            this.callback.onFail();
        }
    }

    public String performPostCall(String requestURL, Map<String, String> postDataParams) {
        InputStream inputStream = null;
        String response = "";
        try {
            URL url = new URL(requestURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write(this.getPostDataString(postDataParams));
            writer.flush();
            writer.close();
            os.close();
            int responseCode = conn.getResponseCode();
            response = responseCode == 200 ? ((inputStream = conn.getInputStream()) != null ? this.convertInputStreamToString(inputStream) : "Did not work!") : "";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private String convertInputStreamToString(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String line = "";
        String result = "";
        while ((line = bufferedReader.readLine()) != null) {
            result = result + line;
        }
        inputStream.close();
        return result;
    }

    private String getPostDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }
}

