/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.base;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.text.Html;
import android.view.MenuItem;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.base.Presenter;
import uk.co.chrisjenx.calligraphy.CalligraphyContextWrapper;

public abstract class BaseActivity
extends AppCompatActivity {
    protected Presenter presenter;
    protected ProgressDialog progressDialog;

    protected abstract void initializeDagger();

    protected abstract void savedInstance(Bundle var1);

    protected abstract void initializePresenter();

    public abstract int getLayoutId();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getLayoutId());
        this.savedInstance(savedInstanceState);
        this.initializeDagger();
        this.initializePresenter();
        if (this.presenter != null) {
            this.presenter.initialize(this.getIntent().getExtras());
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.presenter != null) {
            this.presenter.start();
        }
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onStop() {
        super.onStop();
        if (this.presenter != null) {
            this.presenter.finalizeView();
        }
    }

    public void setTitle(CharSequence resId) {
        if (this.getSupportActionBar() != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.getSupportActionBar().setTitle((CharSequence)Html.fromHtml((String)resId.toString(), (int)0));
            } else {
                this.getSupportActionBar().setTitle((CharSequence)Html.fromHtml((String)resId.toString()));
            }
            this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void attachBaseContext(Context context) {
        super.attachBaseContext((Context)CalligraphyContextWrapper.wrap((Context)context));
    }

    protected void setBackEnabled(boolean flag) {
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(flag);
            this.getSupportActionBar().setHomeButtonEnabled(flag);
        }
    }

    protected void showProgressDialog(String message) {
        if (this.progressDialog == null || !this.progressDialog.isShowing()) {
            this.progressDialog = new ProgressDialog((Context)this);
            this.progressDialog.setMessage((CharSequence)message);
            this.progressDialog.setCanceledOnTouchOutside(false);
            if (!this.isFinishing()) {
                this.progressDialog.show();
            }
        }
    }

    protected void hideProgressDialog() {
        if (this.progressDialog != null && this.progressDialog.isShowing() && !this.isFinishing()) {
            this.progressDialog.dismiss();
        }
    }

    protected void showDialog(String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(R.string.app_name);
        if (message != null) {
            builder.setMessage((CharSequence)Html.fromHtml((String)message));
        } else {
            builder.setMessage((CharSequence)"");
        }
        builder.setPositiveButton(17039370, null);
        if (!this.isFinishing()) {
            builder.show();
        }
    }
}

