/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.content.Context;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Oliveboard {
    private static final String TAG = Oliveboard.class.getName();
    static Oliveboard instance;
    Context mActivity;
    private Class sdkWrapper;

    public static Oliveboard getInstance() {
        if (instance == null) {
            instance = new Oliveboard();
        }
        return instance;
    }

    public void startSdk(Context context) {
        this.mActivity = context;
        String driverWrapperClassName = "in.oliveboard.sdk.ui.StartOliveBoard";
        try {
            this.sdkWrapper = Class.forName(driverWrapperClassName);
            this.invokeMethod(this.loadMethod("init", Context.class), context);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    private Method loadMethod(String methodName, Class ... parameterClass) {
        Method loadMethod = null;
        try {
            if (this.sdkWrapper != null) {
                loadMethod = this.sdkWrapper.getMethod(methodName, parameterClass);
            } else {
                Log.e((String)TAG, (String)"sdkWrapper is null");
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return loadMethod;
    }

    private Object invokeMethod(Method method, Object ... params) {
        if (params.length == 0) {
            params = new Object[]{};
        }
        try {
            Object obj = this.sdkWrapper.newInstance();
            return method.invoke(obj, params);
        }
        catch (InvocationTargetException ite) {
            Log.e((String)"ITE", (String)ite.getCause().getMessage(), (Throwable)ite);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("" + e.getMessage()));
        }
        return new Object();
    }
}

