package in.oliveboard.sdk.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;


import in.oliveboard.sdk.R;


public class TriangleShapeView extends View {

    public int colorCode = Color.WHITE;

    public int getColorCode() {
        return colorCode;
    }

    public void setColorCode(int colorCode) {
        this.colorCode = colorCode;
    }
    Context mContext;

    public TriangleShapeView(Context context) {
        super(context);
        this.mContext=context;
    }

    public TriangleShapeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext=context;
    }

    public TriangleShapeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext=context;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        int w = (getWidth()-10) / 2;
        int h = (getHeight()-10) / 2;

        Path path = new Path();
        path.moveTo(0, 0);
        path.lineTo(w, 2 * h);
        path.lineTo(2 * w, 0);
        path.lineTo(0, 0);

        path.close();

        @SuppressLint("DrawAllocation")
        Paint p = new Paint();
        p.setShadowLayer(1, 0, 0, ContextCompat.getColor(mContext, R.color.cardview_shadow_start_colora));

        // Important for certain APIs
        setLayerType(LAYER_TYPE_SOFTWARE, p);
        p.setColor(colorCode);
        p.setAntiAlias(true);

        canvas.drawPath(path, p);
    }
}