package in.oliveboard.sdk.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.preference.PreferenceManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;

import in.oliveboard.sdk.BuildConfig;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.LanguageNotifier;
import in.oliveboard.sdk.presenter.model.MockSingleDataModel;
import in.oliveboard.sdk.presenter.model.OtherTestDataModel;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.SummeryBaseResponse;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;


public class LargeAppInfo {
    ArrayList<TestAppModel> filterArray;
    TestResponseModel testResponseData;
    ArrayList<TestAppModel> questionAnswerInfo;
    TreeMap<Integer, SectionKeyValue> questionSet;
    int language = Constants.LANGUAGE_ENGLISH;
    boolean canEndSession = false;
    public static LargeAppInfo largeAppInfo;

    public static synchronized LargeAppInfo getInstance() {
        if (largeAppInfo == null) {
            largeAppInfo = new LargeAppInfo();
        }
        return largeAppInfo;


    }

    public void setQuestionInfo(TestResponseModel testResonseData) {
        this.testResponseData = testResonseData;
    }

    public TestResponseModel getQuestionInfo() {
        return testResponseData;
    }

    public void setQuestionAnswerInfo(ArrayList<TestAppModel> questionAnswerInfo) {
        this.questionAnswerInfo = questionAnswerInfo;
    }

    public ArrayList<TestAppModel> getQuestionAnswerInfo() {
        return questionAnswerInfo;
    }

    public void setBaseFilterArray(ArrayList<TestAppModel> filterArray) {
        this.filterArray = filterArray;
    }


    public ArrayList<TestAppModel> getBaseFilterArray() {
        return filterArray;
    }

    public ArrayList<TestAppModel> currentQuestionInfo = new ArrayList<>();

    public void setCurrentQuestionInfo(ArrayList<TestAppModel> currentQuestionInfo) {
        this.currentQuestionInfo.clear();
        this.currentQuestionInfo.addAll(currentQuestionInfo);
    }

    public int getLanguageType() {
        return language;
    }

    public void setLanguageType(int language) {
        this.language = language;
    }

    public ArrayList<TestAppModel> getCurrentQuestionInfo() {
        return currentQuestionInfo;
    }

    public boolean canEndSession() {
        return canEndSession;
    }

    public void setCanEndSession(boolean canEndSession) {
        this.canEndSession = canEndSession;
    }


    public void clearAllData() {
        if (questionSize > 0) {
            questionSize = 0;
        }
        if (filterArray != null) {
            filterArray.clear();
        }
        if (questionAnswerInfo != null) {
            questionAnswerInfo.clear();
        }
        if (panesList != null) {
            panesList.clear();
        }

        if (solutionFilterList != null) {
            solutionFilterList.clear();
        }
        canEndSession = false;
        language = Constants.LANGUAGE_ENGLISH;
    }

    public void setQuestionSet(TreeMap<Integer, SectionKeyValue> questionSet) {
        this.questionSet = questionSet;
    }

    public TreeMap<Integer, SectionKeyValue> getQuestionSet() {
        return questionSet;
    }

    LinkedHashMap<String, ArrayList<String>> panesList;

    public void setPanesList(LinkedHashMap<String, ArrayList<String>> panesList) {
        this.panesList = panesList;
    }

    public LinkedHashMap<String, ArrayList<String>> getPanesList() {
        return panesList;
    }

    HashMap<Integer, ArrayList<FilterModel>> solutionFilterList = new HashMap<>();

    public void setSolutionfilter(int key, ArrayList<FilterModel> filterData) {
        solutionFilterList.put(key, filterData);
    }

    public ArrayList<FilterModel> getSolutionfilter(int key) {
        return solutionFilterList.get(key);
    }


    int switchToQuestion;

    public void switchToPauseQuestion(int switchToQuestion) {
        this.switchToQuestion = switchToQuestion;
    }

    public int getSwitchToQuestion() {
        return switchToQuestion;
    }

    public void setQuestionSize(int questionSize) {
        this.questionSize = questionSize;
    }

    public int getQuestionSize() {
        return questionSize;
    }

    int questionSize = 0;

    boolean shouldShowTimer = false;

    public boolean isTimerShow() {
        return shouldShowTimer;
    }

    public void setTimerRunning(boolean shouldShowTimer) {

        this.shouldShowTimer = shouldShowTimer;
    }

    public void changeLang(String lang,Context context) {

        LocaleContextWrapper.wrap(context, lang);
        SharedPreferences.Editor ed = PreferenceManager.getDefaultSharedPreferences(context).edit();
        ed.putString(context.getString(R.string.locale_lang), lang);
        ed.commit();
        MainEventBus.getInstance().post(new LanguageNotifier());


    }

    public String getLang(Context context){
        return PreferenceManager.getDefaultSharedPreferences(context).getString(context.getString(R.string.locale_lang), "");
    }

    String amount;
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAmount() {
        return amount;
    }
    boolean examRunning=false;
    public void setExamRunning(boolean examRunning) {
        this.examRunning = examRunning;
    }
    public boolean getExamRunning()
    {
        return examRunning;
    }

    public String walletIcon="Some url";
    public String getWalletIcon() {
        return walletIcon;
    }
    public  void setWalletIcon(String walletIcon)
    {
        this.walletIcon=walletIcon;
    }

}
