package in.oliveboard.sdk.ui;

import android.content.Intent;
import android.os.Bundle;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.ui.base.BaseActivity;

import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeAppInfo;


public class TestSectionActivity extends BaseActivity implements CommonContract.View {
    TestPresenter presenter = new TestPresenter();

    @Override
    protected void initializeDagger() {
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);

          showProgressDialog(getString(R.string.str_loading_test));

        if(presenter!=null) {
            LargeAppInfo.getInstance().clearAllData();
            presenter.callNativeTestApp(getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL),TestSectionActivity.this);
        }


    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_solution_infinate_olivesdk;
    }

    @Override
    public void onSuccess(Object responseModel) {

    }

    @Override
    public void onFailed() {

    }

    @Override
    public void onSuccess(List responseModel) {

    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onSuccess(String response) {

    }

    @Override
    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {

    }

    @Override
    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {
        hideProgressDialog();
        if (status) {
            if (response != null) {

                LargeAppInfo.getInstance().setQuestionInfo(response);
                LargeAppInfo.getInstance().setQuestionSet(questionSet);
                LargeAppInfo.getInstance().setQuestionAnswerInfo(restructuredModelList);
                if (getIntent().getExtras() != null && getIntent().getExtras().getBoolean(Constants.BUNDLE_KEY_EXAM_URL)) {
                    startActivity(new Intent(getApplicationContext(), TestModuleActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME,getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra(Constants.BASE_BUNDLE_URL, getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL)).putExtra(Constants.IS_MOCK, true).putExtra(Constants.PART_TEST,true).putExtra(Constants.BUNDLE_SHOULD_CHANGE,true));
                    finish();
                } else {
                    startActivity(new Intent(getApplicationContext(), TestModuleActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME,getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra(Constants.BASE_BUNDLE_URL, getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL)).putExtra(Constants.IS_MOCK, false).putExtra(Constants.PART_TEST,true).putExtra(Constants.BUNDLE_SHOULD_CHANGE,true));
                    finish();
                }
            }
        } else {
            finish();

        }
    }
    @Override
    public void onFailed(String message) {

    }
}
