package in.oliveboard.sdk.ui;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.design.widget.TabLayout;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.squareup.otto.Subscribe;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;


import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.ClearSession;
import in.oliveboard.sdk.presenter.model.MockDataModel;
import in.oliveboard.sdk.presenter.model.OtherTestDataModel;
import in.oliveboard.sdk.presenter.model.RefreshTestInfo;
import in.oliveboard.sdk.presenter.model.SessionOut;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.TestStatusEventModel;
import in.oliveboard.sdk.presenter.model.TimeInfo;
import in.oliveboard.sdk.presenter.model.UpdateTestCount;
import in.oliveboard.sdk.presenter.model.WalletVisibility;
import in.oliveboard.sdk.ui.adapters.BaseModuleAdaptor;
import in.oliveboard.sdk.ui.base.BaseActivity;

import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.MainEventBus;

public class MockTestActivity extends BaseActivity implements CommonContract.View {

    TestPresenter presenter = new TestPresenter();
    LinearLayout tryAgainLayout;
    ProgressBar progressBarLayout;
    TextView toolbarTitle;
    ViewPager viewPager;
    TabLayout tabLayout;
    Toolbar toolbar;
    BaseModuleAdaptor baseAdaptor;
    boolean shouldRefresh = false;
    boolean canChangeTime = false;

    TextView walletAmountTextView;
    public TextView walletTimeTextView;
    LinearLayout baseWalletLayout;
    public ImageView walletImageView;
    boolean onSaveInstanceCalled = false;
    boolean otherTest = false;
    MockDataModel mockData = null;
    OtherTestDataModel otherTestDataModel = null;
    boolean clearFlag=true;


    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void initializeDagger() {

        tryAgainLayout = findViewById(R.id.try_again_layer);
        progressBarLayout = findViewById(R.id.progressbar_layer);
        toolbarTitle = findViewById(R.id.toolbar_txt);
        viewPager = findViewById(R.id.viewpager);
        tabLayout = findViewById(R.id.tabs);
        toolbar = findViewById(R.id.toolbar);
        walletAmountTextView = findViewById(R.id.wallet_amount_text_view);
        walletTimeTextView = findViewById(R.id.wallet_time_text_view);
        baseWalletLayout = findViewById(R.id.base_wallet_layout);
        walletImageView = findViewById(R.id.wallet_icon);

        toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        setSupportActionBar(toolbar);
        setBackEnabled(true);
        toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                backPressHandling();
            }
        });
        tryAgainLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                shouldRefresh = true;
                tryAgainLayout.setVisibility(View.GONE);
                if (presenter != null) {

                    showProgressDialog(getString(R.string.str_please_wait));

                    if (getIntent().getExtras() != null && getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_OTHER_TEST_KEY)) {

                        presenter.callOtherTestInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),MockTestActivity.this);

                    } else {


                        presenter.callMockTestInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),MockTestActivity.this);

                    }
                }
            }
        });

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            toolbarTitle.setText(Html.fromHtml(Objects.requireNonNull(getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_NAME), Html.FROM_HTML_MODE_LEGACY));

        } else {
            toolbarTitle.setText(Html.fromHtml(Objects.requireNonNull(getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_NAME)));

        }

        /*if (getIntent().getExtras() != null && getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_WALLET_TIME)) {
            if (((App) getApplicationContext()).isTimerShow()) {
                canChangeTime = true;
                baseWalletLayout.setVisibility(View.VISIBLE);
                Glide.with(this).load(((App) getApplicationContext()).getWalletIcon()).error(R.drawable.ic_wallet).into(walletImageView);
                walletTimeTextView.setText(getIntent().getExtras().getString(Constants.BUNDLE_KEY_WALLET_TIME));
                walletAmountTextView.setText(getIntent().getExtras().getString(Constants.BUNDLE_KEY_WALLET_AMOUNT));
            }
        }
        else if(getIntent().getExtras()!=null&&getIntent().getExtras().containsKey(Constants.FROM))
        {
            if(!isTaskRoot())
            {
                if (((App) getApplicationContext()).isTimerShow()) {
                    canChangeTime = true;
                    baseWalletLayout.setVisibility(View.VISIBLE);
                    Glide.with(this).load(((App) getApplicationContext()).getWalletIcon()).error(R.drawable.ic_wallet).into(walletImageView);

                    walletAmountTextView.setText(((App) getApplicationContext()).getAmount());

                }
            }
        }*/
        baseWalletLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (LargeDataHandler.getInstance().getWalletUrl() != null) {
                    startActivity(new Intent(getApplicationContext(), TestUpgradeActivity.class).putExtra("action_header", "Plans").putExtra(Constants.PAYMENT_TYPE, LargeDataHandler.getInstance().getWalletUrl()));

                } else {
                    startActivity(new Intent(getApplicationContext(), TestUpgradeActivity.class).putExtra("action_header", "Plans").putExtra(Constants.PAYMENT_TYPE, Constants.BASE_PLAN_WALLET_URL));

                }
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);

        if(getIntent().getExtras()!=null&&getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_MOCK_TEST_TYPE)&&getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE).equals("mock_notification"))
        {
            clearFlag=false;
            MainEventBus.getInstance().post(new ClearSession());
            if (presenter != null) {

                showProgressDialog(getString(R.string.str_please_wait));
//                  showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_please_wait_hindi):getString(R.string.str_please_wait));

                presenter.callMockTestInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),MockTestActivity.this);
            }
        }

        else {

            if (getIntent().getExtras() != null && getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_OTHER_TEST_KEY)) {
                if (LargeDataHandler.getInstance().getCacheOtherTest(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE)) != null) {
                    OtherTestDataModel otherTestDataModel = (OtherTestDataModel) LargeDataHandler.getInstance().getCacheOtherTest(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE));
                    LargeDataHandler.getInstance().setOtherTestModel(otherTestDataModel);
                    otherTest = true;
                    baseAdaptor = new BaseModuleAdaptor(getSupportFragmentManager(), otherTestDataModel);
                    viewPager.setAdapter(baseAdaptor);
                    if (tabLayout != null) {
                        tabLayout.setupWithViewPager(viewPager, false);
                        BasicConfig.getInstance().apply((ViewGroup) tabLayout.getChildAt(0), "fonts/SF-UI-Display_Heavy_Cyrillic.otf", getApplicationContext());
                    }

                    if (getIntent().getExtras().containsKey("banner_name")) {
                        if (!onSaveInstanceCalled) {
                            try {
                                int current = currentObjectTab(getIntent().getExtras().getString("banner_name"), otherTestDataModel.examsList);

                                if (current != -1) {
                                    viewPager.setCurrentItem(current, false);
                                } else {
                                    viewPager.setCurrentItem(0, false);

                                }
                            } catch (Exception e) {
                                Log.d("catch","at catch");
                            }
                        }
                    }


                } else {

                    showProgressDialog(getString(R.string.str_please_wait));
//              showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_please_wait_hindi):getString(R.string.str_please_wait));

                    if (presenter != null) {
                        presenter.callOtherTestInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),MockTestActivity.this);
                    }
                }
            } else {

                if (LargeDataHandler.getInstance().getCacheOtherTest("mock_" + getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE)) != null) {
                    baseAdaptor = new BaseModuleAdaptor(getSupportFragmentManager(), (MockDataModel) LargeDataHandler.getInstance().getCacheOtherTest("mock_" + getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE)));
                    viewPager.setAdapter(baseAdaptor);
                    if (tabLayout != null) {
                        tabLayout.setupWithViewPager(viewPager, false);
                        BasicConfig.getInstance().apply((ViewGroup) tabLayout.getChildAt(0), "fonts/SF-UI-Display_Heavy_Cyrillic.otf", getApplicationContext());
//                        viewPager.setCurrentItem(viewPager.getCurrentItem(),false);
                    }
                    if (getIntent().getExtras().containsKey("banner_name")) {
                        try {
                            if (!onSaveInstanceCalled) {
                                int current = currentTab(getIntent().getExtras().getString("banner_name"), ((MockDataModel) LargeDataHandler.getInstance().getCacheOtherTest("mock_" + getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE))).examsList);

                                if (current != -1) {
                                    viewPager.setCurrentItem(current, false);
                                } else {
                                    viewPager.setCurrentItem(0, false);

                                }
                            }
                        } catch (Exception e) {
                            Log.d("catch","at catch");
                        }
                    }
                } else {
                    if (presenter != null) {

                        showProgressDialog(getString(R.string.str_please_wait));

                        presenter.callMockTestInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),MockTestActivity.this);
                    }
                }
            }
        }

    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_baselayout_olivesdk;
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public void onSuccess(Object responseModel) {

        progressBarLayout.setVisibility(View.GONE);

        tryAgainLayout.setVisibility(View.GONE);

        hideProgressDialog();
        if (responseModel != null) {
            if (responseModel instanceof MockDataModel) {

                String title = null;

                try {

                    if (mockData != null) {
                        title = mockData.examsList.get(viewPager.getCurrentItem()).get(0);
                    }
                } catch (Exception e) {
                    Log.d("catch","at catch");
                }
                mockData = ((MockDataModel) responseModel);
                LargeDataHandler.getInstance().setCacheOtherTest("mock_" + Objects.requireNonNull(getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_TYPE), mockData);
                if (shouldRefresh) {
                    LargeDataHandler.getInstance().clearMockData();
                }

                baseAdaptor = new BaseModuleAdaptor(getSupportFragmentManager(), mockData);
                viewPager.setAdapter(baseAdaptor);
                if (tabLayout != null) {
                    tabLayout.setupWithViewPager(viewPager, false);
                    if (shouldRefresh||getIntent().getExtras().containsKey("banner_name")) {

                        try {
                            int current=-1;
                            if(shouldRefresh) {
                                current = currentTab(title, mockData.examsList);
                                if (current != -1) {
                                    viewPager.setCurrentItem(current, false);
                                } else {
                                    viewPager.setCurrentItem(0, false);

                                }
                            }
                            else if(getIntent().getExtras().containsKey("banner_name"))
                            {
                                if (!onSaveInstanceCalled) {
                                    current = currentTab(getIntent().getExtras().getString("banner_name"), mockData.examsList);
                                    if (current != -1) {
                                        viewPager.setCurrentItem(current, false);
                                    } else {
                                        viewPager.setCurrentItem(0, false);

                                    }
                                }
                            }


                        } catch (Exception e) {
                            Log.d("catch","at catch");
                        }
                    }

                    BasicConfig.getInstance().apply((ViewGroup) tabLayout.getChildAt(0), "fonts/SF-UI-Display_Heavy_Cyrillic.otf", getApplicationContext());
                }
            }
        }
        shouldRefresh = false;
    }

    @Override
    public void onFailed() {
        hideProgressDialog();
        shouldRefresh = false;
        progressBarLayout.setVisibility(View.GONE);
        if (viewPager.getChildCount() == 0) {
            tryAgainLayout.setVisibility(View.VISIBLE);
        } else {
            tryAgainLayout.setVisibility(View.GONE);
        }
    }

    @Override
    public void onSuccess(List responseModel) {

    }

    @Override
    public void onFailed(String message) {

    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onSuccess(String response) {

    }

    @Override
    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {

    }

    @Override
    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {

    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {

        getMenuInflater().inflate(R.menu.menu_refresh, menu);
        return super.onCreateOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        int id = item.getItemId();
        if (id == R.id.action_refresh) {
            shouldRefresh = true;
            tryAgainLayout.setVisibility(View.GONE);
            if (presenter != null) {

                showProgressDialog(getString(R.string.str_please_wait));

                if (getIntent().getExtras() != null && getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_OTHER_TEST_KEY)) {

                    presenter.callOtherTestInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),MockTestActivity.this);

                } else {


                    presenter.callMockTestInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),MockTestActivity.this);

                }
            }

            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onResume() {
        super.onResume();
        try {
            MainEventBus.getInstance().register(this);
        } catch (Exception e) {
            Log.d("catch","at catch");
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (presenter != null) {
            presenter.unSubscribe();
            LargeDataHandler.getInstance().clearOtherTestInfo();
        }
        try {
            MainEventBus.getInstance().unregister(this);
        } catch (Exception e) {
            Log.d("catch","at catch");
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Subscribe
    public void getTestSubmitStatus(TestStatusEventModel statusEventModel) {
        // listen for subscribed event
        if (Objects.requireNonNull(getIntent().getExtras()).containsKey(Constants.BUNDLE_KEY_OTHER_TEST_KEY)) {
            if (statusEventModel.refreshWholeTest) {
                if (presenter != null) {
                    presenter.callOtherTestInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),MockTestActivity.this);
                }
                MainEventBus.getInstance().post(new UpdateTestCount());

            }

        }
    }



    @Subscribe
    public void onSessionOut(SessionOut sessionOut) {

        finish();

    }


    @Subscribe
    public void onClearFlag(ClearSession flag)
    {
        if(clearFlag) {
            finish();
        }
        clearFlag=false;
    }

    @Subscribe
    public void onRefresh(RefreshTestInfo refresh) {
        if (otherTest) {
            if (presenter != null) {
                shouldRefresh = false;

                if (getIntent().getExtras() != null && getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_OTHER_TEST_KEY)) {
                    presenter.callOtherTestInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),MockTestActivity.this);

                }
            }
        }
    }

    @Subscribe
    public void onLiveTimeRunning(TimeInfo time) {
        if (canChangeTime) {
            if (time.time.equals("00:00:00")) {
                baseWalletLayout.setVisibility(View.GONE);
            }
            walletTimeTextView.setText(time.time);
        }

    }

    @Subscribe
    public void onWalletVisible(WalletVisibility info) {
        if (baseWalletLayout != null) {
            canChangeTime = true;
            baseWalletLayout.setVisibility(View.VISIBLE);
            walletAmountTextView.setText(info.amout);
            walletTimeTextView.setText(info.time);
            Glide.with(this).load(LargeAppInfo.getInstance().getWalletIcon()).error(R.drawable.ic_wallet).into(walletImageView);

        }

    }

    @Override
    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putBoolean("savedData", true);
        // Always call the superclass so it can save the view hierarchy state
        super.onSaveInstanceState(savedInstanceState);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null && savedInstanceState.containsKey("savedData")) {
            onSaveInstanceCalled = savedInstanceState.getBoolean("savedData");
        }
    }

    public int currentTab(String examName, ArrayList<ArrayList<String>> examsList) {

        try {

            if (examName != null) {

                int index = -1;

                for (int i = 0; i < examsList.size(); i++) {

                    if (examsList.get(i).get(0).equalsIgnoreCase(examName)) {

                        index = i;
                        break;
                    }
                }

                return index;

            } else {

                return -1;

            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return -1;
    }

    public int currentObjectTab(String examName, ArrayList<Object> examsList) {
        try {

            if (examName != null) {
                int index = -1;
                for (int i = 0; i < examsList.size(); i+=2) {
                    if (((String) examsList.get(i)).equalsIgnoreCase(examName)) {
                        index = i/2;

                        break;
                    }
                }
                return index;
            } else {
                return -1;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return -1;
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();

        if (getIntent().getExtras()!=null&&getIntent().getExtras().containsKey("from_notification")) {

            startActivity(new Intent(getApplicationContext(), HomeActivity.class));
            finish();
        }
        else
        {
            backPressHandling();
        }


    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);

        startActivity(intent);
        finish();

    }

    public void backPressHandling()
    {
        try {
            if (!isTaskRoot()) {
                finish();
            } else {
                if (getIntent().getExtras() != null && getIntent().getExtras().containsKey(Constants.FROM)) {
                    startActivity(new Intent(getApplicationContext(), HomeActivity.class));
                    finish();
                } else {
                    finish();
                }

            }
        }
        catch (Exception e)
        {
            finish();
        }
    }
}
