package in.oliveboard.sdk.ui;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.squareup.otto.Subscribe;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;


import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.MockIndex;
import in.oliveboard.sdk.presenter.model.ReCheckWallet;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.TimeInfo;
import in.oliveboard.sdk.presenter.model.WalletInfo;
import in.oliveboard.sdk.presenter.model.WalletVisibility;
import in.oliveboard.sdk.timer.Counter;
import in.oliveboard.sdk.timer.OliveBoardWalletTimer;
import in.oliveboard.sdk.timer.TimerStatus;
import in.oliveboard.sdk.timer.listener.TimerListener;
import in.oliveboard.sdk.ui.adapters.AllBanksAdapter;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.MainEventBus;

public class HomeActivity extends BaseActivity implements CommonContract.View ,TimerListener {
    TestPresenter presenter = new TestPresenter();

    Toolbar toolbar;
    LinearLayout tryAgainLayout;
    ProgressBar progressBarLayout;
    TextView walletAmountTextView;
    TextView walletTimeTextView;
    LinearLayout baseWalletLayout;
    ImageView walletImageView;
    TextView toolbarTitle;
    boolean canChangeTime = false;
    boolean isActive = true;

    RecyclerView recyclerView;
    ArrayList<Object> mockTestExamList=new ArrayList<>();
    AllBanksAdapter allBankAdaptor;

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void initializeDagger() {
        walletAmountTextView = findViewById(R.id.wallet_amount_text_view);
        walletTimeTextView = findViewById(R.id.wallet_time_text_view);
        baseWalletLayout = findViewById(R.id.base_wallet_layout);
        walletImageView = findViewById(R.id.wallet_icon);
        toolbarTitle = findViewById(R.id.toolbar_txt);
        recyclerView = findViewById(R.id.recycler_view);
        toolbar = findViewById(R.id.toolbar);
        tryAgainLayout = findViewById(R.id.try_again_layer);
        progressBarLayout = findViewById(R.id.progressbar_layer);

        toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        setSupportActionBar(toolbar);
        setBackEnabled(true);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            toolbarTitle.setText(Html.fromHtml(Objects.requireNonNull(getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_NAME), Html.FROM_HTML_MODE_LEGACY));

        } else {
            toolbarTitle.setText(Html.fromHtml(Objects.requireNonNull(getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_NAME)));

        }

        toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!isTaskRoot()) {

                    finish();
                }
                else {
                    Intent i = new Intent(getApplicationContext(), HomeActivity.class);
                    startActivity(i);
                    finish();
                }
            }
        });


        recyclerView.setHasFixedSize(true);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        allBankAdaptor=new AllBanksAdapter(getApplicationContext(),mockTestExamList);
        recyclerView.setAdapter(allBankAdaptor);

        baseWalletLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (LargeDataHandler.getInstance().getWalletUrl() != null) {
                    startActivity(new Intent(getApplicationContext(), TestUpgradeActivity.class).putExtra("action_header", "Plans").putExtra(Constants.PAYMENT_TYPE, LargeDataHandler.getInstance().getWalletUrl()));

                } else {
                    startActivity(new Intent(getApplicationContext(), TestUpgradeActivity.class).putExtra("action_header", "Plans").putExtra(Constants.PAYMENT_TYPE, Constants.BASE_PLAN_WALLET_URL));

                }
            }
        });

        tryAgainLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (presenter != null) {
                    progressBarLayout.setVisibility(View.VISIBLE);
                    tryAgainLayout.setVisibility(View.GONE);
                    presenter.callMockSectionalInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),HomeActivity.this);
                } else {
                    progressBarLayout.setVisibility(View.GONE);
                    tryAgainLayout.setVisibility(View.VISIBLE);

                }
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);
        if (LargeDataHandler.getInstance().getMockSectionalData(Objects.requireNonNull(getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_NAME))==null) {
            showProgressDialog(getString(R.string.str_please_wait));
            presenter.callMockSectionalInfo(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),HomeActivity.this);
            //presenter.callWalletInfo(Constants.BASE_WALLET_URL);
        }
        else
        {

            mockTestExamList.addAll(LargeDataHandler.getInstance().getMockSectionalData(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_NAME)));

            allBankAdaptor.notifyDataSetChanged();
        }

    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_home_olivesdk;
    }

    @Override
    public void onSuccess(Object responseModel) {
        if (responseModel instanceof WalletInfo) {
            WalletInfo info = (WalletInfo) responseModel;
            LargeDataHandler.getInstance().setWalletUrl(info.walletOfferUrl);

            if (info.walletExpireTime > 0 && info.walletBalance != null && !(info.walletBalance.equals("0"))) {

                String amount = info.walletBalance;
                if (walletAmountTextView != null && baseWalletLayout != null) {
                    try {
                        Integer.parseInt(info.walletBalance);
                        amount = getString(R.string.Rso) + " " + Integer.parseInt(info.walletBalance);
                    } catch (Exception e) {
                        amount = " " + amount;
                    }
                    walletAmountTextView.setText(amount);
                    baseWalletLayout.setVisibility(View.VISIBLE);
                    Glide.with(this).load(info.walletImageUrl).error(R.drawable.ic_wallet).into(walletImageView);
                }
                LargeAppInfo.getInstance().setTimerRunning(true);
                LargeAppInfo.getInstance().setAmount(amount);
                LargeAppInfo.getInstance().setWalletIcon(info.walletImageUrl);
                try {

                    OliveBoardWalletTimer.getInstance().finish();

                } catch (Exception e) {
                    Log.d("catch","at catch");
                }

                OliveBoardWalletTimer.getInstance().init(new Counter.CounterBuilder((info.walletExpireTime)).build(), HomeActivity.this).setTime();

                try {

                    OliveBoardWalletTimer.getInstance().startTimer(false);

                } catch (Exception e) {
                    e.printStackTrace();
                    if (walletTimeTextView != null && baseWalletLayout != null) {

                        baseWalletLayout.setVisibility(View.GONE);
                        walletTimeTextView.setText("");
                        LargeAppInfo.getInstance().setTimerRunning(false);

                    }
                }
//                }
                if (!isActive) {
                    if (walletTimeTextView != null && walletTimeTextView.getText().toString().length() > 2) {
                        MainEventBus.getInstance().post(new WalletVisibility(walletTimeTextView.getText().toString(), walletAmountTextView.getText().toString()));
                    }
                }


            }
        }
    }

    @Override
    public void onFailed() {
        if(!isFinishing() && progressBarLayout!=null && tryAgainLayout!=null) {
            hideProgressDialog();
            // shouldRefresh = false;
            progressBarLayout.setVisibility(View.GONE);
            if (LargeDataHandler.getInstance().getMockSectionalData(getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_NAME)) == null) {
                tryAgainLayout.setVisibility(View.VISIBLE);
            } else {
                tryAgainLayout.setVisibility(View.GONE);
            }
        }

    }

    @Override
    public void onSuccess(List responseModel) {
        if (progressBarLayout != null) {
            progressBarLayout.setVisibility(View.GONE);
        }
        if (tryAgainLayout != null) {
            tryAgainLayout.setVisibility(View.GONE);
        }
        Log.d("ush","cameif3333333");
        hideProgressDialog();

        if (responseModel instanceof ArrayList) {

            ///This is a method how you want to navigate on click(Set Adaptor Here)
            mockTestExamList.clear();
            LargeDataHandler.getInstance().setMockSectionalData((ArrayList<Object>) responseModel, getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_NAME));
            mockTestExamList.addAll((ArrayList<Object>) responseModel);
            if (allBankAdaptor != null) {
                allBankAdaptor.notifyDataSetChanged();
            }
        }
        else
        {
            if (mockTestExamList.size()==0) {
                tryAgainLayout.setVisibility(View.VISIBLE);
            } else {
                tryAgainLayout.setVisibility(View.GONE);
            }
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public void onFailed(String message) {
        if(!isFinishing() && progressBarLayout!=null && tryAgainLayout!=null) {
            hideProgressDialog();
            progressBarLayout.setVisibility(View.GONE);
            if (LargeDataHandler.getInstance().getMockSectionalData(Objects.requireNonNull(getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_NAME)) == null) {
                tryAgainLayout.setVisibility(View.VISIBLE);
            } else {
                tryAgainLayout.setVisibility(View.GONE);
            }
        }
    }



    @Override
    public void onAuthFailed() {

    }

    @Override
    public void onSuccess(String response) {

    }

    @Override
    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accuracy) {

    }

    @Override
    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {

    }


    @Subscribe
    public void onLiveTimeRunning(TimeInfo time) {
        if (canChangeTime) {
            if (time.time.equals("00:00:00")) {
                baseWalletLayout.setVisibility(View.GONE);
            }
            walletTimeTextView.setText(time.time);
        }

    }

    @Subscribe
    public void navigateToTest(MockIndex mockData)
    {
        if (mockTestExamList.size() > 0) {

            Intent intent = new Intent(getApplicationContext(), MockTestActivity.class);
           /* if (baseWalletLayout != null && baseWalletLayout.getVisibility() == View.VISIBLE) {
                intent.putExtra(Constants.BUNDLE_KEY_WALLET_TIME, walletTimeTextView.getText().toString());
                intent.putExtra(Constants.BUNDLE_KEY_WALLET_AMOUNT, walletAmountTextView.getText().toString());

            }*/

            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, mockData.url);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, mockData.name);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME, mockData.name);

            startActivity(intent);
        }

    }

    @Subscribe
    public void onWalletVisible(WalletVisibility info) {
        if (baseWalletLayout != null) {
            canChangeTime = true;
            baseWalletLayout.setVisibility(View.VISIBLE);
            walletAmountTextView.setText(info.amout);
            walletTimeTextView.setText(info.time);
            Glide.with(this).load(LargeAppInfo.getInstance().getWalletIcon()).error(R.drawable.ic_wallet).into(walletImageView);

        }

    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {

        getMenuInflater().inflate(R.menu.menu_refresh, menu);
        return super.onCreateOptionsMenu(menu);
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        int id = item.getItemId();
        if (id == R.id.action_refresh) {

            if (presenter != null) {

                showProgressDialog(getString(R.string.str_please_wait));
                LargeDataHandler.getInstance().clearTestData();
                presenter.callMockSectionalInfo(Objects.requireNonNull(getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),HomeActivity.this);


            }

            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onResume() {
        super.onResume();

        if (!isActive) {
            isActive = true;
        }
        try {
            MainEventBus.getInstance().register(this);
        } catch (Exception e) {

            Log.d("catch","at catch");
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (presenter != null) {
            presenter.unSubscribe();
        }
        try {
            MainEventBus.getInstance().unregister(this);
        } catch (Exception e) {
            Log.d("catch","at catch");
        }
        OliveBoardWalletTimer.getInstance().finish();
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        showProgressDialog(getString(R.string.str_please_wait));
        presenter.callMockSectionalInfo(Objects.requireNonNull(intent.getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_URL),HomeActivity.this);

    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        backPressHandling();
    }

    public void backPressHandling()
    {
        try {
            if (!isTaskRoot()) {
                finish();
            } else {
                if (getIntent().getExtras() != null && getIntent().getExtras().containsKey(Constants.FROM)) {
                    startActivity(new Intent(getApplicationContext(), HomeActivity.class));
                    finish();
                } else {
                    finish();
                }

            }
        }
        catch (Exception e)
        {
            finish();
        }
    }

    @Subscribe
    public void reCheckWallet(ReCheckWallet walletInfo) {
       /* if (presenter != null) {
            presenter.callWalletInfo(Constants.BASE_WALLET_URL);
        }*/

    }

    @Override
    public void onTimerChanged(TimerStatus status) {
        if (status == TimerStatus.FINISHED) {
            if(walletTimeTextView!=null&&baseWalletLayout!=null) {
                baseWalletLayout.setVisibility(View.GONE);
                walletTimeTextView.setText("");
            }
            LargeAppInfo.getInstance().setTimerRunning(false);

        }
    }

    @Override
    public void onLiveTimeRunning(String time) {
        try {
            walletTimeTextView.setText(time);
            if (!isActive) {

                MainEventBus.getInstance().post(new TimeInfo(time));
            }
        } catch (NullPointerException e) {
            e.printStackTrace();
            if (baseWalletLayout!=null&&walletTimeTextView!=null&&baseWalletLayout.getVisibility() == View.VISIBLE) {
                baseWalletLayout.setVisibility(View.GONE);
                walletTimeTextView.setText("");
                LargeAppInfo.getInstance().setTimerRunning(false);

            }
        }
    }
}
