package in.oliveboard.sdk.communication;

import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.model.WalletInfo;
import in.oliveboard.sdk.presenter.model.WalletPlanInfo;
import in.oliveboard.sdk.utils.BaseSharedPreferences;

public final class HTTPAsyncTaskWalletData extends AsyncTask<String, Void, String> {
    String url;
    BaseCallback callback;
    BaseSharedPreferences baseSharedPreferences;
    String cookieAuthtoken;
    String cookieVersion;
    String cookieDeviceid;

    public HTTPAsyncTaskWalletData(String url, String cookieAuthtoken, String cookieVersion, String cookieDeviceid, BaseCallback callback){
        this.url = url;
        this.cookieAuthtoken = cookieAuthtoken;
        this.cookieVersion = cookieVersion;
        this.cookieDeviceid = cookieDeviceid;
        this.callback = callback;
    }

    @Override
    protected String doInBackground(String... urls) {
        try {
            return performPostCall(url,cookieAuthtoken,cookieVersion,cookieDeviceid);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void onPostExecute(String result) {
        if (result != null) {
            Log.d("ush", "HTTPAsyncTaskWalletData asynnnnnnnnnnnnnnnnnnnnnnnn  " + result);
            WalletInfo walletInfo = new Gson().fromJson(result, WalletInfo.class);
if(walletInfo!=null) {
    callback.onSuccess(walletInfo);
}
        }
        else
        {
//            callback.onFail();
        }
    }

    public String  performPostCall(String requestURL,String cookieAuthtoken, String cookieVersion, String cookieDeviceid) {
        InputStream inputStream = null;
        URL url;
        String response = "";

        try {
            url = new URL(requestURL);

            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("POST");
            conn.addRequestProperty("Cookie",cookieAuthtoken);
            conn.addRequestProperty("X-version",cookieVersion);
            conn.addRequestProperty("X-deviceid",cookieDeviceid);
            conn.setDoInput(true);
            conn.setDoOutput(true);

            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(os, "UTF-8"));
            writer.flush();
            writer.close();
            os.close();
            int responseCode=conn.getResponseCode();

            if (responseCode == HttpsURLConnection.HTTP_OK) {
                inputStream = conn.getInputStream();
                if(inputStream != null)
                    response = convertInputStreamToString(inputStream);
                else
                    response = "Did not work!";
            }
            else {
                response="";

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return response;
    }

    private  String convertInputStreamToString(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader( new InputStreamReader(inputStream));
        String line = "";
        String result = "";
        while((line = bufferedReader.readLine()) != null)
            result += line;

        inputStream.close();
        return result;

    }
}