package in.oliveboard.sdk.communication;

import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.model.MockDataModel;
import in.oliveboard.sdk.presenter.model.MockSingleDataModel;
import in.oliveboard.sdk.utils.BaseSharedPreferences;

public final class HTTPAsyncTaskMockSingleTest extends AsyncTask<String, Void, String> {
    String url;
    BaseCallback callback;
    BaseSharedPreferences baseSharedPreferences;
    String cookieAuthtoken;
    String cookieVersion;
    String cookieDeviceid;

    public HTTPAsyncTaskMockSingleTest(String url, String cookieAuthtoken, String cookieVersion, String cookieDeviceid, BaseCallback callback){
        this.url = url;
        this.cookieAuthtoken = cookieAuthtoken;
        this.cookieVersion = cookieVersion;
        this.cookieDeviceid = cookieDeviceid;
        this.callback = callback;
    }

    @Override
    protected String doInBackground(String... urls) {
        try {
            return performPostCall(url,cookieAuthtoken,cookieVersion,cookieDeviceid);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void onPostExecute(String result) {
        if(result!=null) {
            MockSingleDataModel mockSingleDataModel = new Gson().fromJson(result, MockSingleDataModel.class);

            if (mockSingleDataModel.isAuthenticated != null && mockSingleDataModel.isAuthenticated.equals("0")) {
                callback.onAuthFailed();
            } else {
                callback.onSuccess(mockSingleDataModel);
            }
        }
        else
        {
            callback.onFail();
        }

//        Log.d("ush","HTTPAsyncTaskMockSingleTest asynnnnnnnnnnnnnnnnnnnnnnnnuauth  "+mockSingleDataModel.isAuthenticated);
//        Log.d("ush","HTTPAsyncTaskMockSingleTest asynnnnnnnnnnnnnnnnnnnnnnnnnewreg  "+mockSingleDataModel.buyUrl);
    }

    public String  performPostCall(String requestURL,String cookieAuthtoken, String cookieVersion, String cookieDeviceid) {
        InputStream inputStream = null;
        URL url;
        String response = "";

        try {
            url = new URL(requestURL);

            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("POST");
            conn.addRequestProperty("Cookie",cookieAuthtoken);
            conn.addRequestProperty("X-version",cookieVersion);
            conn.addRequestProperty("X-deviceid",cookieDeviceid);
            conn.setDoInput(true);
            conn.setDoOutput(true);

            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(os, "UTF-8"));
            writer.flush();
            writer.close();
            os.close();
            int responseCode=conn.getResponseCode();

            if (responseCode == HttpsURLConnection.HTTP_OK) {
                inputStream = conn.getInputStream();
                if(inputStream != null)
                    response = convertInputStreamToString(inputStream);
                else
                    response = "Did not work!";
            }
            else {
                response="";

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return response;
    }

    private  String convertInputStreamToString(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader( new InputStreamReader(inputStream));
        String line = "";
        String result = "";
        while((line = bufferedReader.readLine()) != null)
            result += line;

        inputStream.close();
        return result;

    }
}