package in.oliveboard.sdk.ui.fragments;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.ui.adapters.SolutionFilterAdapter;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.FilterAsyncTask;
import in.oliveboard.sdk.utils.FilterInterface;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.RecyclerItemClickListener;

public class SolutionAppFilterFragment extends Fragment implements FilterInterface {
    RecyclerView recyclerView;
    ArrayList<TestAppModel> questionDataList;
    ArrayList<TestAppModel> filterArrayList = new ArrayList<>();



    public static SolutionAppFilterFragment newInstance(int index){
        SolutionAppFilterFragment fragment=new SolutionAppFilterFragment();
        Bundle args = new Bundle();
        args.putInt(Constants.INDEX,index);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v=inflater.inflate(R.layout.recycler_fragment_olivesdk, container,false);
        recyclerView = v.findViewById(R.id.recycler_view_fragment);
        return v;
    }
    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        questionDataList= LargeAppInfo.getInstance().getBaseFilterArray();
        if(questionDataList!=null) {


            assert getArguments() != null;
            if (getArguments().getInt(Constants.INDEX) == Constants.TYPE_ALL) {
                filterArrayList.clear();
                filterArrayList.addAll(questionDataList);
                SolutionFilterAdapter adapter = new SolutionFilterAdapter(filterArrayList, getActivity(), getArguments().getInt(Constants.INDEX), (LargeAppInfo.getInstance().getLanguageType()));

                recyclerView.setAdapter(adapter);
                recyclerView.setHasFixedSize(true);
                recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
            } else if (getArguments().getInt(Constants.INDEX) == Constants.FILTER_CORRECT) {

               new FilterAsyncTask(0, Constants.FILTER_CORRECT_TYPE,questionDataList,this,0).execute();

//                filterArrayList.addAll(FilterQuestions.getInstance().filter(questionDataList, Constants.FILTER_CORRECT_TYPE).get(0).getFilterArrayList());
            } else if (getArguments().getInt(Constants.INDEX) == Constants.FILTER_UN_ATTEMPTED) {
//                filterArrayList.addAll(FilterQuestions.getInstance().filter(questionDataList, Constants.FILTER_UN_ATTEMPTED_TYPE).get(0).getFilterArrayList());
                new FilterAsyncTask(0, Constants.FILTER_UN_ATTEMPTED_TYPE,questionDataList,this,0).execute();

            } else if (getArguments().getInt(Constants.INDEX) == Constants.FILTER_WRONG) {
//                filterArrayList.addAll(FilterQuestions.getInstance().filter(questionDataList, Constants.FILTER_WRONG_TYPE).get(0).getFilterArrayList());
                new FilterAsyncTask(0, Constants.FILTER_WRONG_TYPE,questionDataList,this,0).execute();

            }


        }
        else
        {
            getActivity().finish();
        }


            recyclerView.addOnItemTouchListener(
                    new RecyclerItemClickListener(getActivity(), recyclerView, new RecyclerItemClickListener.OnItemClickListener() {
                        @Override
                        public void onItemClick(View view, int position) {
                            Intent returnIntent = new Intent();
                            returnIntent.putExtra(Constants.FILTER_TYPE, getArguments().getInt(Constants.INDEX));
                            returnIntent.putExtra(Constants.FILTER_POSITION, position);
                            getActivity().setResult(Activity.RESULT_OK, returnIntent);
                            getActivity().finish();
                        }

                        @Override
                        public void onItemLongClick(View view, int position) {

                        }
                    })
            );
        }


    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public void ongetFilterResult(ArrayList<FilterModel> filterData, int position) {
        if(filterData!=null&&filterData.size()>0) {
            filterArrayList.clear();
            filterArrayList .addAll( filterData.get(0).getFilterArrayList());
            assert getArguments() != null;
            SolutionFilterAdapter adapter = new SolutionFilterAdapter(filterArrayList, getActivity(), getArguments().getInt(Constants.INDEX), (LargeAppInfo.getInstance().getLanguageType()));

            recyclerView.setAdapter(adapter);
            recyclerView.setHasFixedSize(true);
            recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
        }
    }


}
