package in.oliveboard.sdk.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

import java.util.List;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeDataHandler;

public class ShowOliveBoard extends AppCompatImageView implements AppCompatImageView.OnClickListener{

    public Context mContext;

    public ShowOliveBoard(Context context) {
        super(context);
        mContext = context;
        setCustomTypeface(context, null);
        setOnClickListener(this);
    }

    public ShowOliveBoard(Context context, AttributeSet attrs) {
        super(context, attrs);
        mContext = context;
        setCustomTypeface(context, attrs);
        setOnClickListener(this);

    }

    public ShowOliveBoard(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        setCustomTypeface(context, attrs);
        setOnClickListener(this);
    }

    @TargetApi(Build.VERSION_CODES.JELLY_BEAN)
    private void setCustomTypeface(Context context, AttributeSet attrs)  {
        if(isInEditMode())
            return;
        @SuppressLint("CustomViewStyleable") TypedArray a = context.obtainStyledAttributes(attrs, android.support.v7.appcompat.R.styleable.TextAppearance);
        setImageResource(R.drawable.applogo_ads);
        a.recycle();

    }

    @Override
    public void onClick(View view) {
        try {
            if(!BasicConfig.getInstance().getAuthData(mContext).isEmpty()) {

                if (LargeDataHandler.getInstance().getMockTestUrl() != null) {
                    Intent intent = new Intent(mContext, HomeActivity.class);
                    intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, LargeDataHandler.getInstance().getMockTestUrl());
                    intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
                    intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME, "Oliveboard Mock Tests");
                    mContext.startActivity(intent);
                } else {
                    mContext.startActivity(new Intent(mContext, LoadingUrlActivity.class));
                }
            }else
            {
                Intent intent = new Intent(mContext, SignupOliveBoardActivity.class);
                mContext.startActivity(intent);

            }
        }catch (Exception e){
        }
    }


}


