/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.presenter;

import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.base.Presenter;
import in.oliveboard.sdk.presenter.interfaces.AuthCallback;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.usecase.AuthUseCase;
import java.util.List;
import java.util.Map;

public class AuthPresenter
extends Presenter<AuthContract.View>
implements AuthCallback {
    private final AuthUseCase authUseCase = new AuthUseCase();
    private final BaseCallback callback = new BaseCallback(){

        @Override
        public void onSuccess() {
        }

        public void onSuccess(Object model) {
            if (AuthPresenter.this.getView() != null) {
                ((AuthContract.View)AuthPresenter.this.getView()).onLoginSuccess(model);
            }
        }

        @Override
        public void onSuccess(String response) {
        }

        @Override
        public void onSolutionSuccess(TestResponseModel model) {
        }

        @Override
        public void onLoginSuccess(String token) {
            if (AuthPresenter.this.getView() != null) {
                ((AuthContract.View)AuthPresenter.this.getView()).loginSuccess(token);
            }
        }

        @Override
        public void onAuthFailed() {
            ((AuthContract.View)AuthPresenter.this.getView()).onAuthFailed();
        }

        @Override
        public void onFail() {
            if (AuthPresenter.this.getView() != null) {
                ((AuthContract.View)AuthPresenter.this.getView()).onFailed();
            }
        }

        @Override
        public void onFail(String message) {
            if (AuthPresenter.this.getView() != null) {
                ((AuthContract.View)AuthPresenter.this.getView()).onFailed(message);
            }
        }

        public void onSuccess(List model) {
        }
    };

    @Override
    public void onUserRegister(Map<String, String> userInfo) {
        if (this.authUseCase != null) {
            this.authUseCase.getSignUpResponse(this.callback, userInfo);
        }
    }

    @Override
    public void onUserLogin(Map<String, String> userInfo) {
        if (this.authUseCase != null) {
            this.authUseCase.getLoginResponse(this.callback, userInfo);
        }
    }

    @Override
    public void onUserChangePassword(Map<String, String> userInfo) {
        if (this.authUseCase != null) {
            this.authUseCase.getChangePasswordResponse(this.callback, userInfo);
        }
    }
}

