/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Bundle;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TextInputLayout;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Toast;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.AuthPresenter;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.Utils;
import java.util.HashMap;

public class ForgotPasswordActivity
extends BaseActivity
implements AuthContract.View {
    LinearLayout view_parent;
    Toolbar toolbar;
    EditText mEditText;
    TextInputLayout mInput;
    Button mSubmit;
    CoordinatorLayout baseLayout;
    private String in_email;
    AuthPresenter presenter = new AuthPresenter();

    @Override
    protected void initializeDagger() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.mEditText = (EditText)this.findViewById(R.id.input_forgot_email);
        this.mInput = (TextInputLayout)this.findViewById(R.id.input_layout_forgot_email);
        this.baseLayout = (CoordinatorLayout)this.findViewById(R.id.cordinate);
        this.view_parent = (LinearLayout)this.findViewById(R.id.parent_view);
        this.mSubmit = (Button)this.findViewById(R.id.btn_submit);
        this.setSupportActionBar(this.toolbar);
        this.toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        this.setBackEnabled(true);
        this.setTitle("Change password?");
        this.mEditText.addTextChangedListener((TextWatcher)new MyTextWatcher((View)this.mEditText));
        this.mSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!ForgotPasswordActivity.this.validateForm()) {
                    return;
                }
                if (Utils.isConnectionAvailable((Context)ForgotPasswordActivity.this)) {
                    if (ForgotPasswordActivity.this.presenter != null) {
                        ForgotPasswordActivity.this.showProgressDialog(ForgotPasswordActivity.this.getString(R.string.str_please_wait));
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("e", ForgotPasswordActivity.this.in_email);
                        ForgotPasswordActivity.this.presenter.onUserChangePassword(map);
                    } else {
                        Snackbar.make((View)view, (CharSequence)"Reopen this page and try again", (int)0).show();
                    }
                } else {
                    Snackbar.make((View)view, (CharSequence)"No internet connection", (int)0).show();
                }
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    protected void initializePresenter() {
        ((BaseActivity)this).presenter = this.presenter;
        this.presenter.setView(this);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_forgot_pwd_olivesdk;
    }

    @Override
    public void loginSuccess(String token) {
        this.hideProgressDialog();
        if (token.equalsIgnoreCase("1")) {
            LayoutInflater inflater = LayoutInflater.from((Context)this);
            View inflatedLayout = inflater.inflate(R.layout.activity_pwd_reset_olivesdk, null, false);
            Button b = (Button)inflatedLayout.findViewById(R.id.btn_go_back);
            b.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ForgotPasswordActivity.this.finish();
                }
            });
            this.view_parent.removeAllViews();
            this.view_parent.addView(inflatedLayout);
        }
    }

    @Override
    public void onFailed() {
        this.hideProgressDialog();
        Utils.showToast((Context)this, "Email not registered");
    }

    @Override
    public void onFailed(String message) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Please try again", (int)0).show();
    }

    @Override
    public void onAuthFailed() {
    }

    public void onLoginSuccess(Object responseModel) {
    }

    @TargetApi(value=21)
    public boolean validateForm() {
        return this.validateEmail();
    }

    private boolean validateEmail() {
        this.in_email = this.mEditText.getEditableText().toString().trim();
        if (this.in_email.isEmpty() || !ForgotPasswordActivity.isValidEmail(this.in_email)) {
            try {
                this.mInput.setError((CharSequence)this.getString(R.string.err_msg_email));
            }
            catch (NoSuchFieldError e) {
                Snackbar.make((View)this.baseLayout, (CharSequence)this.getString(R.string.err_msg_email), (int)0).show();
            }
            this.requestFocus((View)this.mEditText);
            return false;
        }
        try {
            this.mInput.setErrorEnabled(false);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        return true;
    }

    private static boolean isValidEmail(String email) {
        return !TextUtils.isEmpty((CharSequence)email) && Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    private void requestFocus(View view) {
        if (view.requestFocus()) {
            this.getWindow().setSoftInputMode(5);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    private class MyTextWatcher
    implements TextWatcher {
        private View view;

        private MyTextWatcher(View view) {
            this.view = view;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void afterTextChanged(Editable editable) {
            int i = this.view.getId();
            if (i == R.id.input_forgot_email) {
                // empty if block
            }
        }
    }
}

