package in.oliveboard.sdk.utils;

import android.content.DialogInterface;
import android.graphics.drawable.BitmapDrawable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.CardView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.widget.Toast;


import java.util.ArrayList;
import java.util.TreeMap;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestDialogInfo;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.ui.adapters.QuickActionAdaptor;

public class DialogUtils {
    public static DialogUtils dialogUtils;
    boolean isStartTest;

    public static synchronized DialogUtils getInstance() {
        if (dialogUtils == null) {
            dialogUtils = new DialogUtils();
        }
        return dialogUtils;
    }

    AlertDialog alertD=null;

    public void selfStopDialog(AppCompatActivity context, final onDialogUtilCalled dialogUtilCalled, boolean isNextTest) {
        View promptView = context.getLayoutInflater().inflate(R.layout.auto_submit_dialog_olivesdk, null);
//        TextView title=(TextView)promptView.findViewById(R.id.t1);
//        title.setText("Your time is over we are submitting. please wait");
        alertD = new AlertDialog.Builder(context).create();
        alertD.setCancelable(false);
        alertD.setCanceledOnTouchOutside(false);
        Button mSubmit = promptView.findViewById(R.id.auto_submit_test);
        alertD.setView(promptView);
        alertD.show();
//        if(isNextTest)
//        {
            mSubmit.setText("Please wait...");
//        }
        mSubmit.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
//                dialogUtilCalled.onAutoDialogSelected();
            }
        });
    }

    public void closeSelfDialog() {
        try {
            if (alertD != null) {
                alertD.dismiss();
            }
        }
        catch (Exception e)
        {

        }
    }

    public void startTestDialog(final AppCompatActivity context, TestResponseModel testInfo, final onDialogUtilCalled dialogUtilCalled, boolean isResume) {
        isStartTest = false;
        View promptView = context.getLayoutInflater().inflate(R.layout.testapp_custom_dialog_olivesdk, null);
        final AlertDialog alertD = new AlertDialog.Builder(context).create();
//        alertD.setCancelable(false);
//        alertD.setCanceledOnTouchOutside(false);
        alertD.setView(promptView);
        TextView testNameTextView = promptView.findViewById(R.id.start_test_title);
        TextView timeStringTextView = promptView.findViewById( R.id.start_test_duration);
        TextView questionTextView = promptView.findViewById( R.id.start_test_question_count);
        TextView marksCorrectTextView = promptView.findViewById( R.id.start_test_correct_marks);
        TextView correctTextView = promptView.findViewById( R.id.start_test_correct);
        TextView wrongTextView = promptView.findViewById( R.id.start_test_wrong);

        TextView marksWrongTextView = promptView.findViewById( R.id.start_tset_worng_marks);

//        ImageView closeTestButton = promptView.findViewById(R.id.close_btn);
        Button startTestButton = promptView.findViewById( R.id.start_test);
        if(isResume)
        {
            startTestButton.setText("RESUME TEST");
        }
//        CardView startTestCard= promptView.findViewById(R.id.start_test_card_view);

//        CardView startTestButton = (CardView) promptView.findViewById(R.id.start_test_card_view);
        alertD.show();
        testNameTextView.setText(testInfo.questionId);
        questionTextView.setText("" + testInfo.settings.numberOfQuestion);
        timeStringTextView.setText(testInfo.settings.totalTimeString);
        if (testInfo.settings.cwmap != null && testInfo.settings.cwmap.size() >= 2) {
            marksCorrectTextView.setText(testInfo.settings.cwmap.get(0));
            marksWrongTextView.setText(testInfo.settings.cwmap.get(1));
        }
        else
        {
            marksCorrectTextView.setVisibility(View.GONE);
            marksWrongTextView.setVisibility(View.GONE);
            correctTextView.setVisibility(View.GONE);
            wrongTextView.setVisibility(View.GONE);
        }
        alertD.setOnDismissListener(new DialogInterface.OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialogInterface) {
                if (!isStartTest) {
                    if(dialogUtilCalled!=null) {
                        dialogUtilCalled.startTest(false);
                    }
                }
            }
        });
        startTestButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                isStartTest = true;
                alertD.dismiss();
                if(dialogUtilCalled!=null) {
                    dialogUtilCalled.startTest(true);
                }
            }
        });

    }

    public void exitDialog(AppCompatActivity context, final onDialogUtilCalled onDialogUtilCalled) {

        LayoutInflater layoutInflater = LayoutInflater.from(context);
        View promptView = layoutInflater.inflate(R.layout.dialog_exit_test_olivesdk, null);

        final AlertDialog alertD = new AlertDialog.Builder(context).create();
        alertD.setCancelable(false);
        Button btnAdd1 = (Button) promptView.findViewById(R.id.okBtn);
        Button btnAdd2 = (Button) promptView.findViewById(R.id.cancelBtn);

        btnAdd1.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                alertD.dismiss();
                if(onDialogUtilCalled!=null) {
                    onDialogUtilCalled.onExitApp();
                }

            }
        });

        btnAdd2.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                alertD.cancel();
            }
        });

        alertD.setView(promptView);
        alertD.show();
    }

    public void displayPopupWindow(View anchorView, AppCompatActivity context, TreeMap<Integer, SectionKeyValue> questionSet, final onDialogUtilCalled dialogUtilCalled, String selectedOption) {
        final PopupWindow popup = new PopupWindow(context);

        View layout = context.getLayoutInflater().inflate(R.layout.quickaction_dialog_olivesdk, null);
        RecyclerView list = (RecyclerView) layout.findViewById(R.id.recycler_view);
        popup.setContentView(layout);
        // Set content width and height
        popup.setHeight(WindowManager.LayoutParams.WRAP_CONTENT);
        popup.setWidth(WindowManager.LayoutParams.WRAP_CONTENT);
        // Closes the popup window when touch outside of it - when looses focus
        popup.setOutsideTouchable(true);
        popup.setFocusable(true);
        // Show anchored to button
        popup.setBackgroundDrawable(new BitmapDrawable());
        popup.showAsDropDown(anchorView);
        list.setLayoutManager(new LinearLayoutManager(context));
        list.setAdapter(new QuickActionAdaptor(context, questionSet, selectedOption));

        list.addOnItemTouchListener(
                new RecyclerItemClickListener(context, list, new RecyclerItemClickListener.OnItemClickListener() {
                    @Override
                    public void onItemClick(View view, int position) {

                        popup.dismiss();
                        if(dialogUtilCalled!=null) {
                            dialogUtilCalled.onOptionDialogSelected(position);
                        }

                    }

                    @Override
                    public void onItemLongClick(View view, int position) {

                    }
                })
        );
    }

    public void submitTestDialog(AppCompatActivity context, ArrayList<TestAppModel> questionAnswerInfo, final onDialogUtilCalled dialogUtilCalled, boolean isNextTest) {
        final ArrayList<TestDialogInfo> summeryInfo = FilterQuestions.getInstance().getSummeryInfo(questionAnswerInfo);

        View promptView = context.getLayoutInflater().inflate(R.layout.test_submit_dialog_olivesdk, null);
        final AlertDialog alertD = new AlertDialog.Builder(context).create();
//        alertD.setCancelable(false);
//        alertD.setCanceledOnTouchOutside(false);

        TextView mark = promptView.findViewById( R.id.marked_count);
        TextView attempt = promptView.findViewById( R.id.attempted_count);
        TextView unAttempt = promptView.findViewById( R.id.un_attempted_count);
        Button mResume = promptView.findViewById( R.id.resume_test);
        Button mSubmit = promptView.findViewById( R.id.submit_test);

        alertD.setView(promptView);

        alertD.show();
        if(isNextTest)
        {
            mSubmit.setText("Next Section");
        }
        unAttempt.setText(String.valueOf(summeryInfo.get(0).getUnattemped()));
        mark.setText(String.valueOf(summeryInfo.get(0).getFav()));
        attempt.setText(String.valueOf(summeryInfo.get(0).getAttempted()));

        mSubmit.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                alertD.cancel();
                if(dialogUtilCalled!=null) {
                    dialogUtilCalled.onSubmitDialogSelected();
                }

            }
        });

        mResume.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertD.cancel();


            }
        });
    }

    public void gotoPurchaseDialog(Fragment context, final onDialogUtilCalled dialogUtilCalled) {
    LayoutInflater layoutInflater = LayoutInflater.from(context.getActivity());
    View promptView = layoutInflater.inflate(R.layout.upgrade_alert_dialog_olivesdk, null);

    final AlertDialog alertD = new AlertDialog.Builder(context.getActivity()).create();
    alertD.setCancelable(true);
    Button btnAdd1 = (Button) promptView.findViewById(R.id.saveBtn);
    Button btnAdd2 = (Button) promptView.findViewById(R.id.cancelBtn);

    btnAdd1.setOnClickListener(new View.OnClickListener() {
        public void onClick(View v) {

            alertD.cancel();
            if(dialogUtilCalled!=null) {
                dialogUtilCalled.gotoPurchase();
            }

        }
    });

    btnAdd2.setOnClickListener(new View.OnClickListener() {
        public void onClick(View v) {
            alertD.cancel();
        }
    });

    alertD.setView(promptView);
    alertD.show();
}

    public void tryAgainSubmit(AppCompatActivity context, final onDialogUtilCalled onDialogUtilCalled) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setCancelable(false);
        builder.setTitle("Try Again");
        builder.setMessage("Submit test failed. Do you want to try again?");
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                if(onDialogUtilCalled!=null) {
                    onDialogUtilCalled.onTryAgain();
                }
//                onDialogUtilCalled.onExitApp();
            }
        });
        builder.setNegativeButton("No", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                if(onDialogUtilCalled!=null) {
                    onDialogUtilCalled.onExitWithoutPause();
                }
            }
        });
        builder.show();
    }


    public void pauseOrResumeTest(final AppCompatActivity context, final onDialogUtilCalled onDialogUtilCalled, String title, String message, final String positiveButton, final String cancel) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        // builder.setCancelable(false);
        builder.setTitle(title);
        builder.setMessage(message);
        builder.setPositiveButton(positiveButton, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();

                if(onDialogUtilCalled!=null) {
                    onDialogUtilCalled.onPauseTest(true);
                }


//                onDialogUtilCalled.onExitApp();
            }
        });
        builder.setNegativeButton(cancel, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                if(onDialogUtilCalled!=null) {
                    onDialogUtilCalled.onPauseTest(false);
                }
//                if(isResume) {
//                    onDialogUtilCalled.onExitWithoutPause();
//                }
            }
        });
        //builder.show();
        AlertDialog alertDialog=builder.create();
        alertDialog.show();
        alertDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {
            @Override
            public void onCancel(DialogInterface dialog) {
                // Toast.makeText(context,"cancelcalled",Toast.LENGTH_SHORT).show();
                dialog.dismiss();
                if(onDialogUtilCalled!=null) {
                    onDialogUtilCalled.onPauseTest(false);
                }
            }
        });
    }

    public void displayInfoPopupWindow(String percentage, String level, View anchorView, Fragment context) {
        final PopupWindow popup = new PopupWindow(context.getActivity());

        View layout = context.getActivity().getLayoutInflater().inflate(R.layout.quickaction_solution_info_dialog_olivesdk, null);
        popup.setContentView(layout);
        TextView percentageTextView = (TextView) layout.findViewById(R.id.percentage_text_view);
        TextView levelTextView = (TextView) layout.findViewById(R.id.level_text_view);
        levelTextView.setText(level);
        percentageTextView.setText(percentage);
        // Set content width and height
        popup.setHeight(WindowManager.LayoutParams.WRAP_CONTENT);
        popup.setWidth(WindowManager.LayoutParams.WRAP_CONTENT);
        // Closes the popup window when touch outside of it - when looses focus
        popup.setOutsideTouchable(true);
        popup.setFocusable(true);
        // Show anchored to button
        popup.setBackgroundDrawable(new BitmapDrawable());
        popup.showAsDropDown(anchorView);


    }


    public void startSolutionSummeryDialog(final AppCompatActivity context, final onDialogUtilCalled dialogUtilCalled, String totalTime, String totalQuestions, String testName, final boolean initialLoad, String totalMark, int correctAnswer, int wrongAnser, String accuracyString) {


        View promptView = context.getLayoutInflater().inflate(R.layout.test_summary_dialog_olivesdk, null);
        final AlertDialog alertD = new AlertDialog.Builder(context).create();
        if (initialLoad) {
            alertD.setCancelable(false);
            alertD.setCanceledOnTouchOutside(false);
        }
//        alertD.setCancelable(false);
//        alertD.setCanceledOnTouchOutside(false);
        alertD.setView(promptView);
        TextView testNameTextView = promptView.findViewById( R.id.test_name_txt);
        TextView timeStringTextView = promptView.findViewById( R.id.test_time_txt);
        TextView questionTextView = promptView.findViewById( R.id.test_questions_number_txt);
        ImageView closeTestButton = promptView.findViewById( R.id.dialog_close);


        TextView correctTextView = promptView.findViewById( R.id.test_summary_right_count);
        TextView wrongTextView = promptView.findViewById( R.id.test_summary_wrong_count);
        TextView totalTextView = promptView.findViewById( R.id.test_summary_totalScore);
        TextView accurecyTextView = promptView.findViewById( R.id.test_summary_accuracy_percentage);

        Button viewSolutionButton = promptView.findViewById( R.id.start_test_button_view);
        CardView startTestCard = promptView.findViewById( R.id.start_test_card_view);
        correctTextView.setText("" + correctAnswer);
        wrongTextView.setText("" + wrongAnser);
        if (accuracyString.equals("0.00 % ")) {
            accurecyTextView.setText("0 %");

        } else {
            accurecyTextView.setText(accuracyString);

        }
        totalTextView.setText(totalMark);

        if (totalTime != null) {
            timeStringTextView.setText(totalTime);
        }
        if (totalQuestions != null) {
            questionTextView.setText(totalQuestions);
        }
        if (testName != null) {
            testNameTextView.setText(testName);
        }
        if (!initialLoad) {
            viewSolutionButton.setText(context.getResources().getString(R.string.solution_text));
        }
//        CardView startTestButton = (CardView) promptView.findViewById(R.id.start_test_card_view);
        alertD.show();
        viewSolutionButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertD.dismiss();

            }
        });
        closeTestButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertD.dismiss();
                if (initialLoad) {
                    if(dialogUtilCalled!=null) {
                        dialogUtilCalled.onExitApp();
                    }

                }
            }
        });
        startTestCard.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertD.dismiss();
            }
        });

    }

    public void singleDialog(AppCompatActivity context, String message, String title, String ok, final onDialogUtilCalled onDialogUtilCalled) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setCancelable(false);
        builder.setTitle(title);
        builder.setMessage(message);
        builder.setPositiveButton(ok, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                if(onDialogUtilCalled!=null) {
                    onDialogUtilCalled.onExitApp();
                }
//                onDialogUtilCalled.onExitApp();
            }
        });
//        builder.setNegativeButton("no", new DialogInterface.OnClickListener() {
//            public void onClick(DialogInterface dialog, int id) {
//                dialog.dismiss();
//                onDialogUtilCalled.onExitApp();
//            }
//        });
        builder.show();
    }

    public void multipleOptionFragmentDialog(FragmentActivity context, final onDialogOptionCalled onDialogUtilCalled, String title, String message, String positiveMessage, String negativeMessage) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setCancelable(false);
        builder.setTitle(title);
        builder.setMessage(message);
        builder.setPositiveButton(positiveMessage, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                if(onDialogUtilCalled!=null) {
                    onDialogUtilCalled.onPositiveClick();
                }
//                onDialogUtilCalled.onExitApp();
            }
        });
        builder.setNegativeButton(negativeMessage, new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                if(onDialogUtilCalled!=null) {
                    onDialogUtilCalled.onNegativeClick();
                }
            }
        });

        builder.show();
    }

    public void permissionAlerts(final AppCompatActivity context, final onDialogUtilCalled dialogUtilCalled, final BaseSharedPreferences baseSharedPreferences) {
        final AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(context);
        alertDialogBuilder.setTitle("Permissions Required")
                .setMessage("Without this permission the app is unable to send you new test updates and other features. Are you sure to deny this permission?")
                .setPositiveButton("RE-TRY", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        dialogUtilCalled.retyPermission();
                    }
                })
                .setNegativeButton("I'M SURE", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        permissionPermanentDenyAlerts(context, dialogUtilCalled, false, "You have forcefully denied some of the required permissions" +
                                "\nIf it was by accident you can allow the permission again ", "Try again",baseSharedPreferences);
                    }
                })
                .setCancelable(false)
                .create()
                .show();

    }

    public void permissionPermanentDenyAlerts(final AppCompatActivity context, final onDialogUtilCalled dialogUtilCalled, final boolean gotoSetting, String message, String positiveOption, final BaseSharedPreferences baseSharedPreferences) {
        final AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(context);
        alertDialogBuilder.setTitle("Permissions Required")
                .setMessage(message)
                .setPositiveButton(positiveOption, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        if (gotoSetting) {
                            dialogUtilCalled.openPermissionSetting();
                        } else {
                            dialogUtilCalled.retyPermission();
                        }
                    }
                })
                .setNegativeButton("Don't show again", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
//                        Utils.showToast(context, " permission not granted");
                        Toast.makeText(context,"permisson not granded",Toast.LENGTH_SHORT).show();

                        baseSharedPreferences.putData(Constants.PHONE_PERMISSION, -1);
                        baseSharedPreferences.putData(Constants.PHONE_PERMISSION_PERMENENT_DENIED, -1);
                        dialogUtilCalled.noPhoneAction();
                    }
                })
                .setCancelable(false)
                .create()
                .show();
    }

}

