/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.squareup.otto.Subscribe;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.MockIndex;
import in.oliveboard.sdk.presenter.model.ReCheckWallet;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.TimeInfo;
import in.oliveboard.sdk.presenter.model.WalletInfo;
import in.oliveboard.sdk.presenter.model.WalletVisibility;
import in.oliveboard.sdk.timer.Counter;
import in.oliveboard.sdk.timer.OliveBoardWalletTimer;
import in.oliveboard.sdk.timer.TimerStatus;
import in.oliveboard.sdk.timer.listener.TimerListener;
import in.oliveboard.sdk.ui.MockTestActivity;
import in.oliveboard.sdk.ui.TestUpgradeActivity;
import in.oliveboard.sdk.ui.adapters.AllBanksAdapter;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.MainEventBus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

public class HomeActivity
extends BaseActivity
implements CommonContract.View,
TimerListener {
    TestPresenter presenter = new TestPresenter();
    Toolbar toolbar;
    LinearLayout tryAgainLayout;
    ProgressBar progressBarLayout;
    TextView walletAmountTextView;
    TextView walletTimeTextView;
    LinearLayout baseWalletLayout;
    ImageView walletImageView;
    TextView toolbarTitle;
    boolean canChangeTime = false;
    boolean isActive = true;
    RecyclerView recyclerView;
    ArrayList<Object> mockTestExamList = new ArrayList();
    AllBanksAdapter allBankAdaptor;

    @Override
    @RequiresApi(api=19)
    protected void initializeDagger() {
        this.walletAmountTextView = (TextView)this.findViewById(R.id.wallet_amount_text_view);
        this.walletTimeTextView = (TextView)this.findViewById(R.id.wallet_time_text_view);
        this.baseWalletLayout = (LinearLayout)this.findViewById(R.id.base_wallet_layout);
        this.walletImageView = (ImageView)this.findViewById(R.id.wallet_icon);
        this.toolbarTitle = (TextView)this.findViewById(R.id.toolbar_txt);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.tryAgainLayout = (LinearLayout)this.findViewById(R.id.try_again_layer);
        this.progressBarLayout = (ProgressBar)this.findViewById(R.id.progressbar_layer);
        this.toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.setBackEnabled(true);
        if (Build.VERSION.SDK_INT >= 24) {
            this.toolbarTitle.setText((CharSequence)Html.fromHtml((String)Objects.requireNonNull(this.getIntent().getExtras()).getString("com.title.bundle.language"), (int)0));
        } else {
            this.toolbarTitle.setText((CharSequence)Html.fromHtml((String)Objects.requireNonNull(this.getIntent().getExtras()).getString("com.title.bundle.language")));
        }
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!HomeActivity.this.isTaskRoot()) {
                    HomeActivity.this.finish();
                } else {
                    Intent i = new Intent(HomeActivity.this.getApplicationContext(), HomeActivity.class);
                    HomeActivity.this.startActivity(i);
                    HomeActivity.this.finish();
                }
            }
        });
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.allBankAdaptor = new AllBanksAdapter(this.getApplicationContext(), this.mockTestExamList);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.allBankAdaptor);
        this.baseWalletLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (LargeDataHandler.getInstance().getWalletUrl() != null) {
                    HomeActivity.this.startActivity(new Intent(HomeActivity.this.getApplicationContext(), TestUpgradeActivity.class).putExtra("action_header", "Plans").putExtra(Constants.PAYMENT_TYPE, LargeDataHandler.getInstance().getWalletUrl()));
                } else {
                    HomeActivity.this.startActivity(new Intent(HomeActivity.this.getApplicationContext(), TestUpgradeActivity.class).putExtra("action_header", "Plans").putExtra(Constants.PAYMENT_TYPE, Constants.BASE_PLAN_WALLET_URL));
                }
            }
        });
        this.tryAgainLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (HomeActivity.this.presenter != null) {
                    HomeActivity.this.progressBarLayout.setVisibility(0);
                    HomeActivity.this.tryAgainLayout.setVisibility(8);
                    HomeActivity.this.presenter.callMockSectionalInfo(HomeActivity.this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL), (Context)HomeActivity.this);
                } else {
                    HomeActivity.this.progressBarLayout.setVisibility(8);
                    HomeActivity.this.tryAgainLayout.setVisibility(0);
                }
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    @RequiresApi(api=19)
    protected void initializePresenter() {
        ((BaseActivity)this).presenter = this.presenter;
        this.presenter.setView(this);
        if (LargeDataHandler.getInstance().getMockSectionalData(Objects.requireNonNull(this.getIntent().getExtras()).getString("com.title.bundle.language")) == null) {
            this.showProgressDialog(this.getString(R.string.str_please_wait));
            this.presenter.callMockSectionalInfo(this.getIntent().getExtras().getString(Constants.BUNDLE_KEY_MOCK_TEST_URL), (Context)this);
        } else {
            this.mockTestExamList.addAll(LargeDataHandler.getInstance().getMockSectionalData(this.getIntent().getExtras().getString("com.title.bundle.language")));
            this.allBankAdaptor.notifyDataSetChanged();
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_home_olivesdk;
    }

    public void onSuccess(Object responseModel) {
        if (responseModel instanceof WalletInfo) {
            WalletInfo info = (WalletInfo)responseModel;
            LargeDataHandler.getInstance().setWalletUrl(info.walletOfferUrl);
            if (info.walletExpireTime > 0L && info.walletBalance != null && !info.walletBalance.equals("0")) {
                block10: {
                    String amount = info.walletBalance;
                    if (this.walletAmountTextView != null && this.baseWalletLayout != null) {
                        try {
                            Integer.parseInt(info.walletBalance);
                            amount = this.getString(R.string.Rso) + " " + Integer.parseInt(info.walletBalance);
                        }
                        catch (Exception e) {
                            amount = " " + amount;
                        }
                        this.walletAmountTextView.setText((CharSequence)amount);
                        this.baseWalletLayout.setVisibility(0);
                        Glide.with((FragmentActivity)this).load(info.walletImageUrl).error(R.drawable.ic_wallet).into(this.walletImageView);
                    }
                    LargeAppInfo.getInstance().setTimerRunning(true);
                    LargeAppInfo.getInstance().setAmount(amount);
                    LargeAppInfo.getInstance().setWalletIcon(info.walletImageUrl);
                    try {
                        OliveBoardWalletTimer.getInstance().finish();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    OliveBoardWalletTimer.getInstance().init(new Counter.CounterBuilder(info.walletExpireTime).build(), this).setTime();
                    try {
                        OliveBoardWalletTimer.getInstance().startTimer(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (this.walletTimeTextView == null || this.baseWalletLayout == null) break block10;
                        this.baseWalletLayout.setVisibility(8);
                        this.walletTimeTextView.setText((CharSequence)"");
                        LargeAppInfo.getInstance().setTimerRunning(false);
                    }
                }
                if (!this.isActive && this.walletTimeTextView != null && this.walletTimeTextView.getText().toString().length() > 2) {
                    MainEventBus.getInstance().post((Object)new WalletVisibility(this.walletTimeTextView.getText().toString(), this.walletAmountTextView.getText().toString()));
                }
            }
        }
    }

    @Override
    public void onFailed() {
        if (!this.isFinishing() && this.progressBarLayout != null && this.tryAgainLayout != null) {
            this.hideProgressDialog();
            this.progressBarLayout.setVisibility(8);
            if (LargeDataHandler.getInstance().getMockSectionalData(this.getIntent().getExtras().getString("com.title.bundle.language")) == null) {
                this.tryAgainLayout.setVisibility(0);
            } else {
                this.tryAgainLayout.setVisibility(8);
            }
        }
    }

    public void onSuccess(List responseModel) {
        if (this.progressBarLayout != null) {
            this.progressBarLayout.setVisibility(8);
        }
        if (this.tryAgainLayout != null) {
            this.tryAgainLayout.setVisibility(8);
        }
        this.hideProgressDialog();
        if (responseModel instanceof ArrayList) {
            this.mockTestExamList.clear();
            LargeDataHandler.getInstance().setMockSectionalData((ArrayList)responseModel, this.getIntent().getExtras().getString("com.title.bundle.language"));
            this.mockTestExamList.addAll((ArrayList)responseModel);
            if (this.allBankAdaptor != null) {
                this.allBankAdaptor.notifyDataSetChanged();
            }
        } else if (this.mockTestExamList.size() == 0) {
            this.tryAgainLayout.setVisibility(0);
        } else {
            this.tryAgainLayout.setVisibility(8);
        }
    }

    @Override
    @RequiresApi(api=19)
    public void onFailed(String message) {
        if (!this.isFinishing() && this.progressBarLayout != null && this.tryAgainLayout != null) {
            this.hideProgressDialog();
            this.progressBarLayout.setVisibility(8);
            if (LargeDataHandler.getInstance().getMockSectionalData(Objects.requireNonNull(this.getIntent().getExtras()).getString("com.title.bundle.language")) == null) {
                this.tryAgainLayout.setVisibility(0);
            } else {
                this.tryAgainLayout.setVisibility(8);
            }
        }
    }

    @Override
    public void onAuthFailed() {
    }

    @Override
    public void onSuccess(String response) {
    }

    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accuracy) {
    }

    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {
    }

    @Subscribe
    public void onLiveTimeRunning(TimeInfo time) {
        if (this.canChangeTime) {
            if (time.time.equals("00:00:00")) {
                this.baseWalletLayout.setVisibility(8);
            }
            this.walletTimeTextView.setText((CharSequence)time.time);
        }
    }

    @Subscribe
    public void navigateToTest(MockIndex mockData) {
        if (this.mockTestExamList.size() > 0) {
            Intent intent = new Intent(this.getApplicationContext(), MockTestActivity.class);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, mockData.url);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, mockData.name);
            intent.putExtra("com.title.bundle.language", mockData.name);
            this.startActivity(intent);
        }
    }

    @Subscribe
    public void onWalletVisible(WalletVisibility info) {
        if (this.baseWalletLayout != null) {
            this.canChangeTime = true;
            this.baseWalletLayout.setVisibility(0);
            this.walletAmountTextView.setText((CharSequence)info.amout);
            this.walletTimeTextView.setText((CharSequence)info.time);
            Glide.with((FragmentActivity)this).load(LargeAppInfo.getInstance().getWalletIcon()).error(R.drawable.ic_wallet).into(this.walletImageView);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_refresh, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    @RequiresApi(api=19)
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_refresh) {
            if (this.presenter != null) {
                this.showProgressDialog(this.getString(R.string.str_please_wait));
                LargeDataHandler.getInstance().clearTestData();
                this.presenter.callMockSectionalInfo(Objects.requireNonNull(this.getIntent().getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_URL), (Context)this);
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (!this.isActive) {
            this.isActive = true;
        }
        try {
            MainEventBus.getInstance().register((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.unSubscribe();
        }
        try {
            MainEventBus.getInstance().unregister((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OliveBoardWalletTimer.getInstance().finish();
    }

    @RequiresApi(api=19)
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.showProgressDialog(this.getString(R.string.str_please_wait));
        this.presenter.callMockSectionalInfo(Objects.requireNonNull(intent.getExtras()).getString(Constants.BUNDLE_KEY_MOCK_TEST_URL), (Context)this);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.backPressHandling();
    }

    public void backPressHandling() {
        try {
            if (!this.isTaskRoot()) {
                this.finish();
            } else if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey("com.from")) {
                this.startActivity(new Intent(this.getApplicationContext(), HomeActivity.class));
                this.finish();
            } else {
                this.finish();
            }
        }
        catch (Exception e) {
            this.finish();
        }
    }

    @Subscribe
    public void reCheckWallet(ReCheckWallet walletInfo) {
    }

    @Override
    public void onTimerChanged(TimerStatus status) {
        if (status == TimerStatus.FINISHED) {
            if (this.walletTimeTextView != null && this.baseWalletLayout != null) {
                this.baseWalletLayout.setVisibility(8);
                this.walletTimeTextView.setText((CharSequence)"");
            }
            LargeAppInfo.getInstance().setTimerRunning(false);
        }
    }

    @Override
    public void onLiveTimeRunning(String time) {
        block3: {
            try {
                this.walletTimeTextView.setText((CharSequence)time);
                if (!this.isActive) {
                    MainEventBus.getInstance().post((Object)new TimeInfo(time));
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                if (this.baseWalletLayout == null || this.walletTimeTextView == null || this.baseWalletLayout.getVisibility() != 0) break block3;
                this.baseWalletLayout.setVisibility(8);
                this.walletTimeTextView.setText((CharSequence)"");
                LargeAppInfo.getInstance().setTimerRunning(false);
            }
        }
    }
}

