/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.timer;

import android.annotation.SuppressLint;
import android.os.CountDownTimer;
import android.widget.TextView;
import in.oliveboard.sdk.timer.Counter;
import in.oliveboard.sdk.timer.TimerStatus;
import in.oliveboard.sdk.timer.listener.TimerListener;
import java.io.IOException;

public class OliveBoardWalletTimer {
    private static final long WARNING_TIME = 180000L;
    private TextView timerTextView;
    private Counter counterConfig;
    @SuppressLint(value={"StaticFieldLeak"})
    private static OliveBoardWalletTimer oliveBoradInstance;
    private TimerListener timerListener;
    private CountDownTimer countDowmTimer;
    private long lastmillisecound = 0L;
    private boolean isTicking = false;

    public static synchronized OliveBoardWalletTimer getInstance() {
        if (oliveBoradInstance == null) {
            oliveBoradInstance = new OliveBoardWalletTimer();
        }
        return oliveBoradInstance;
    }

    public OliveBoardWalletTimer init(TextView timerTextView, Counter counterConfig, TimerListener timerListener) {
        this.timerTextView = timerTextView;
        this.counterConfig = counterConfig;
        this.timerListener = timerListener;
        return this;
    }

    public OliveBoardWalletTimer init(Counter counterConfig, TimerListener timerListener) {
        this.counterConfig = counterConfig;
        this.timerListener = timerListener;
        return this;
    }

    public OliveBoardWalletTimer init(TimerListener timerListener) {
        this.timerListener = timerListener;
        return this;
    }

    public void startTimer(boolean isResume) throws IOException {
        if (this.isTicking && this.countDowmTimer != null) {
            this.countDowmTimer.cancel();
        }
        if (this.counterConfig.getTotalTime() != 0L || this.lastmillisecound != 0L) {
            long secoundtoMilleSecound;
            long l = secoundtoMilleSecound = isResume ? this.lastmillisecound : this.counterConfig.getTotalTime() * 1000L;
            if (!this.isTicking) {
                this.isTicking = true;
                this.countDowmTimer = new CountDownTimer(secoundtoMilleSecound, 1000L){
                    int mDisplayHours;
                    private int mDisplayMinutes;
                    private int mDisplaySeconds;

                    public void onTick(long millisUntilFinished) {
                        OliveBoardWalletTimer.this.lastmillisecound = millisUntilFinished;
                        this.mDisplayHours = (int)(millisUntilFinished / 1000L / 3600L);
                        this.mDisplayMinutes = (int)((millisUntilFinished / 1000L - (long)(this.mDisplayHours * 3600)) / 60L);
                        this.mDisplaySeconds = (int)(millisUntilFinished / 1000L % 60L);
                        if (OliveBoardWalletTimer.this.timerListener != null) {
                            OliveBoardWalletTimer.this.timerListener.onLiveTimeRunning((this.mDisplayHours < 10 ? " 0" + this.mDisplayHours : (this.mDisplayHours < 100 ? " " + this.mDisplayHours : Integer.valueOf(this.mDisplayHours))) + ":" + (this.mDisplayMinutes < 10 ? "0" + this.mDisplayMinutes : Integer.valueOf(this.mDisplayMinutes)) + ":" + (this.mDisplaySeconds < 10 ? "0" + this.mDisplaySeconds : Integer.valueOf(this.mDisplaySeconds)));
                        }
                        if (millisUntilFinished < 180000L && OliveBoardWalletTimer.this.timerListener != null) {
                            OliveBoardWalletTimer.this.timerListener.onTimerChanged(TimerStatus.TIME_ENDING);
                        }
                    }

                    public void onFinish() {
                        if (OliveBoardWalletTimer.this.timerListener != null) {
                            OliveBoardWalletTimer.this.timerListener.onLiveTimeRunning("00:00:00");
                            OliveBoardWalletTimer.this.lastmillisecound = 0L;
                            OliveBoardWalletTimer.this.timerListener.onTimerChanged(TimerStatus.FINISHED);
                        }
                    }
                }.start();
            }
        } else {
            throw new IOException("starting time cannot be 0");
        }
    }

    public void pause() {
        if (this.isTicking) {
            if (this.countDowmTimer != null) {
                this.countDowmTimer.cancel();
                if (this.timerListener != null) {
                    this.timerListener.onTimerChanged(TimerStatus.PAUSED);
                }
            }
            this.isTicking = false;
        }
    }

    public void resume() {
        if (!this.isTicking && this.countDowmTimer != null) {
            try {
                this.startTimer(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.timerListener != null) {
                this.timerListener.onTimerChanged(TimerStatus.RESUMED);
            }
        }
    }

    public void setTime() {
        if (this.counterConfig != null) {
            long millisUntilFinished = (this.counterConfig.getTotalTime() - 1L) * 1000L;
            int mDisplayHours = (int)(millisUntilFinished / 1000L / 3600L);
            int mDisplayMinutes = (int)((millisUntilFinished / 1000L - (long)(mDisplayHours * 3600)) / 60L);
            int mDisplaySeconds = (int)(millisUntilFinished / 1000L % 60L);
            if (this.timerListener != null) {
                this.timerListener.onLiveTimeRunning((mDisplayHours < 10 ? " 0" + mDisplayHours : (mDisplayHours < 100 ? " " + mDisplayHours : Integer.valueOf(mDisplayHours))) + ":" + (mDisplayMinutes < 10 ? "0" + mDisplayMinutes : Integer.valueOf(mDisplayMinutes)) + ":" + (mDisplaySeconds < 10 ? "0" + mDisplaySeconds : Integer.valueOf(mDisplaySeconds)));
            }
        }
    }

    public void finish() {
        this.isTicking = false;
        if (this.countDowmTimer != null) {
            this.countDowmTimer.cancel();
            this.lastmillisecound = 0L;
            if (this.timerListener != null) {
                this.timerListener.onTimerChanged(TimerStatus.FORCE_FINISHED);
            }
        }
    }
}

