package in.sdk;

import android.content.Context;
import android.content.Intent;

import in.oliveboard.sdk.ui.HomeActivity;
import in.oliveboard.sdk.ui.LoadingUrlActivity;
import in.oliveboard.sdk.ui.SignupOliveBoardActivity;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeDataHandler;

public class Oliveboard {

    public static void init(Context context, String anyData){
        if(!BasicConfig.getInstance().getAuthData(context).isEmpty()) {

            if (LargeDataHandler.getInstance().getMockTestUrl() != null) {
                Intent intent = new Intent(context, HomeActivity.class);
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, LargeDataHandler.getInstance().getMockTestUrl());
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME, "Oliveboard Mock Tests");
                context.startActivity(intent);
            } else {
                context.startActivity(new Intent(context, LoadingUrlActivity.class));
            }
        }else
        {
            Intent intent = new Intent(context, SignupOliveBoardActivity.class);
            context.startActivity(intent);
        }
    }

    public static void init(Context context){
        if(!BasicConfig.getInstance().getAuthData(context).isEmpty()) {
            if (LargeDataHandler.getInstance().getMockTestUrl() != null) {
                Intent intent = new Intent(context, HomeActivity.class);
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, LargeDataHandler.getInstance().getMockTestUrl());
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME, "Oliveboard Mock Tests");
                context.startActivity(intent);
            } else {
                context.startActivity(new Intent(context, LoadingUrlActivity.class));
            }
        }else
        {
            Intent intent = new Intent(context, SignupOliveBoardActivity.class);
            context.startActivity(intent);

        }
    }

}
