package in.oliveboard.sdk.ui.base;


import android.app.ProgressDialog;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import in.oliveboard.sdk.presenter.base.BaseView;
import in.oliveboard.sdk.presenter.base.Presenter;


public abstract class BaseFragment extends Fragment implements BaseView {

    protected FragmentManager fragmentManager;

    protected Presenter presenter;

    protected abstract void initializeDagger();

    protected abstract void initializePresenter();

    protected abstract void initializeActivity();

    public abstract int getLayoutId();

    protected View view;

    protected ProgressDialog progressDialog;


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        fragmentManager = getActivity().getSupportFragmentManager();
        setRetainInstance(true);
        initializeDagger();
        initializePresenter();
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        view = inflater.inflate(getLayoutId(), container, false);

        if (presenter != null) {

            presenter.initialize(getArguments());

        }
        return view;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        initializeActivity();
    }

    @Override
    public void onStart() {
        super.onStart();
        if (presenter != null) {
            presenter.start();
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        if (presenter != null) {
            presenter.finalizeView();
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }

protected void showProgressDialog(String message) {


    if (progressDialog == null || !progressDialog.isShowing()) {
        progressDialog = new ProgressDialog(getActivity());
        progressDialog.setMessage(message);
        progressDialog.setCanceledOnTouchOutside(false);
        if (isAdded()) {
            progressDialog.show();
        }
    }

}

    protected void hideProgressDialog() {
        if (progressDialog != null && progressDialog.isShowing()) {
            if (isAdded()) {
                progressDialog.dismiss();
            }
        }
    }
}
