package in.oliveboard.sdk.ui.adapters;

import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;

import in.oliveboard.sdk.presenter.model.MockDataModel;
import in.oliveboard.sdk.presenter.model.OtherTestDataModel;
import in.oliveboard.sdk.ui.fragments.MockFragment;


public class BaseModuleAdaptor extends FragmentStatePagerAdapter {

    private MockDataModel mockDataModel;
    private OtherTestDataModel otherTestDataModel;
    private  String type;

    public BaseModuleAdaptor(FragmentManager fm, MockDataModel mockDataModel) {
        super(fm);
        this.mockDataModel = mockDataModel;
    }

    public BaseModuleAdaptor(FragmentManager fm, OtherTestDataModel otherTestDataModel) {
        super(fm);
        this.otherTestDataModel = otherTestDataModel;
    }

    @Override
    public Fragment getItem(int position) {

        if(otherTestDataModel!=null) {
            return MockFragment.newInstance(position,(String) otherTestDataModel.examsList.get((position*2)));
        }
        else
        {
            return MockFragment.newInstance(position, mockDataModel.examsList.get(position).get(1), mockDataModel.examsList.get(position).get(0));

        }
    }
    @Override
    public int getItemPosition(Object object){
        return PagerAdapter.POSITION_NONE;
    }

    @Override
    public int getCount() {

        if(otherTestDataModel!=null) {

            return otherTestDataModel.examsList.size()/2;

        }
        else
        {
            return mockDataModel.examsList.size();

        }
    }
    @Override
    public CharSequence getPageTitle(int position) {
        if(otherTestDataModel!=null) {
            return (String) otherTestDataModel.examsList.get((position*2));

        }
        else
        {
            return mockDataModel.examsList.get(position).get(0);

        }
    }

    @Override
    public Parcelable saveState()
    {
        return null;
    }
}
