package in.oliveboard.sdk.ui;

import android.content.Context;
import android.util.Log;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Oliveboard {

    private static final String TAG = Oliveboard.class.getName();
    static Oliveboard instance;

    public static Oliveboard getInstance() {
        if(instance == null) {
            instance = new Oliveboard();
        }
        return instance;
    }

    Context mActivity;
    private Class sdkWrapper;

    public void startSdk(Context context) {
        mActivity = context;
        String driverWrapperClassName = "in.oliveboard.sdk.ui.StartOliveBoard";

        try {
            sdkWrapper = Class.forName(driverWrapperClassName);
            invokeMethod(loadMethod("init", Context.class), context);
        } catch (Exception e) {
            Log.e(TAG, e.getMessage(), e);
        }
    }

    private Method loadMethod(String methodName, Class... parameterClass) {
        Method loadMethod = null;
        try {
            if (sdkWrapper != null) {
                loadMethod = sdkWrapper.getMethod(methodName, parameterClass);
            } else {
                Log.e(TAG, "sdkWrapper is null");
            }
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return loadMethod;
    }

    private Object invokeMethod(Method method, Object... params) {
        if (params.length == 0) {
            params = new Object[0];
        }
        try {
            Object obj = sdkWrapper.newInstance();
            return method.invoke(obj, params);
        } catch (InvocationTargetException ite) {
            Log.e("ITE", ite.getCause().getMessage(), ite);
        } catch (Exception e) {
            Log.e(TAG, "" + e.getMessage());
        }
        return new Object();
    }

}