package in.oliveboard.sdk.presenter.usecase;


import android.content.Context;
import android.util.Log;
import android.widget.Toast;

import com.google.gson.Gson;

import java.util.HashMap;
import java.util.Map;

import in.oliveboard.sdk.communication.HTTPAsyncTaskMockSectional;
import in.oliveboard.sdk.communication.HTTPAsyncTaskMockSingleTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskMockTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskNativeSolution;
import in.oliveboard.sdk.communication.HTTPAsyncTaskNativeTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskPauseModuleTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskPauseTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskSubmitTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskSummeryTest;
import in.oliveboard.sdk.communication.HTTPAsyncTaskWalletData;
import in.oliveboard.sdk.communication.HTTPAsyncTaskWalletInfo;
import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.base.UseCase;
import in.oliveboard.sdk.presenter.model.PauseTestData;
import in.oliveboard.sdk.presenter.model.WalletInfo;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.Utils;


public class TestUseCase implements UseCase.TestUseCase {

    private boolean checkInternet(BaseCallback callback, Context context) {
        if(Utils.isConnectionAvailable(context)) {
            return true;
        } else {
            Toast.makeText(context, Constants.ERROR_INTERNET_STATUS, Toast.LENGTH_SHORT).show();
            callback.onFail();
            return false;
        }
    }

    @Override
    public void getMockData(BaseCallback callback, String url, Context context) {
        if(checkInternet(callback, context))
        new HTTPAsyncTaskMockTest(url,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();
    }

    @Override
    public void getSingleTest(BaseCallback callback, String url,Context context) {
        if(checkInternet(callback, context))

        new HTTPAsyncTaskMockSingleTest(url,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();

    }

    @Override
    public void getNativeTest(BaseCallback callback, String url,Context context) {
        if(checkInternet(callback, context))

        new HTTPAsyncTaskNativeTest(url,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();

    }

    @Override
    public void getNativeSolution(BaseCallback callback, String url,Context context) {
        if(checkInternet(callback, context))

        new HTTPAsyncTaskNativeSolution(url,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();

    }

    @Override
    public void getSummeryTest(BaseCallback callback, String url,Context context) {
        if(checkInternet(callback, context))

//        Log.d("ush","auth ** "+BasicConfig.getInstance().getAuthData(context));
//        Log.d("ush","version ** "+BasicConfig.getInstance().getVersion(context));
        new HTTPAsyncTaskSummeryTest(url,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();

    }

    @Override
    public void getSubmitTest(BaseCallback callback, String url, Map<String, String> params,Context context) {
        if(checkInternet(callback, context))

        new HTTPAsyncTaskSubmitTest(url,params,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();

    }

    @Override
    public void getPauseTest(BaseCallback callback, String url, PauseTestData pauseData, String qpi, String userid, String ppid,Context context) {
        if(checkInternet(callback, context))
        if(ppid==null) {
            String data=new Gson().toJson(pauseData);
            Map<String, String> map = new HashMap<String, String>();
            map.put("data", data);
            map.put("qpi", qpi);
            map.put("uid", userid);
            new HTTPAsyncTaskPauseTest(url,map,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();

        }else{
            String data=new Gson().toJson(pauseData);
            Map<String, String> map = new HashMap<String, String>();
            map.put("data", data);
            map.put("qpi", qpi);
            map.put("uid", userid);
            map.put("ppi", ppid);
            new HTTPAsyncTaskPauseModuleTest(url,map,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();
        }
    }

    @Override
    public void getMockSectionalInfo(BaseCallback callback, String url,Context context) {
        if(checkInternet(callback, context))
        new HTTPAsyncTaskMockSectional(url,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();
    }

    public void unSubscribe() {
    }

    @Override
    public void getWalletInfoData(BaseCallback callback, String url,Context context) {
        if(checkInternet(callback, context))
            new HTTPAsyncTaskWalletInfo(url, "uauth=" + BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context), BasicConfig.getInstance().getDeviceId(context), callback).execute();
    }

    @Override
    public void getWalletData(BaseCallback callback, String url,Context context) {
        if(checkInternet(callback, context))
        new HTTPAsyncTaskWalletData(url,"uauth="+ BasicConfig.getInstance().getAuthData(context), BasicConfig.getInstance().getVersion(context),BasicConfig.getInstance().getDeviceId(context),callback).execute();

    }
}
