package in.oliveboard.sdk.presenter.interfaces;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

import in.oliveboard.sdk.presenter.base.BaseView;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;


public interface CommonContract {

    interface View<M> extends BaseView {

        void onSuccess(M responseModel);

        void onFailed();

        void onSuccess(List<M> responseModel);

        void onFailed(String message);

        void onAuthFailed();

        void onTestDataCallback(TestResponseModel response, ArrayList<TestAppModel> restructuredModelList, boolean status, TreeMap<Integer, SectionKeyValue> questionSet);

        void onSolutionDataCallback(TestResponseModel response, ArrayList<TestAppModel> restructuredModelList, boolean status, TreeMap<Integer, SectionKeyValue> questionSet, int correct, int wrong, String accuracy);

        void onSuccess(String response);
    }

}
