package in.oliveboard.sdk.presenter;

import android.content.Context;
import android.util.Base64;
import android.util.Log;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;


import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.base.Presenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.interfaces.TestCallback;
import in.oliveboard.sdk.presenter.model.PauseTestData;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.usecase.TestUseCase;
import in.oliveboard.sdk.utils.Constants;


public class TestPresenter extends Presenter<CommonContract.View> implements TestCallback {

    private final TestUseCase testUseCase = new TestUseCase();


    @Override
    public void unSubscribe() {
        if(testUseCase!=null){
            testUseCase.unSubscribe();
        }
    }

    @Override
    public void callOtherTestInfo(String url, Context context) {
        if(testUseCase!=null){
        }
    }

    @Override
    public void callPauseTest(String url, PauseTestData pauseData, String qpi, String userid, String ppid, Context context) {
        if(testUseCase!=null){
            testUseCase.getPauseTest(callback, url, pauseData, qpi, userid,ppid,context);
        }
    }

    @Override
    public void callPauseModuleTest(String url, PauseTestData pauseData, String qpi, String userid, String ppi) {
        if(testUseCase!=null){
        }
    }


    @Override
    public void callMockTestInfo(String url, Context context) {
        if(testUseCase!=null){
            testUseCase.getMockData(callback, url,context);
        }
    }

    @Override
    public void callMockSingleTest(String url, Context context) {
        if(testUseCase!=null){
            testUseCase.getSingleTest(callback, url,context);
        }
    }

    @Override
    public void callNativeTestApp(String url, Context context) {
        if(testUseCase!=null){
            testUseCase.getNativeTest(callback, url,context);
        }
    }

    @Override
    public void callSummery(String url, Context context) {
        if(testUseCase!=null){
            testUseCase.getSummeryTest(callback, url,context);
        }

    }

    @Override
    public void callSubmitTest(String url, Map<String, String> params, Context context) {
        if(testUseCase!=null){
            testUseCase.getSubmitTest(callback, url, params,context);
        }

    }

    @Override
    public void callSolutionRequest(String url, Context context) {
        if(testUseCase!=null){
            testUseCase.getNativeSolution(callback, url,context);
        }
    }

    public void callMockSectionalInfo(String url,Context context) {
        if(testUseCase!=null){
            testUseCase.getMockSectionalInfo(callback, url, context);
        }
    }

    @Override
    public void callWalletPlan(String url,Context context) {
        if(testUseCase!=null){
            testUseCase.getWalletInfoData(callback, url,context);
        }
    }

    @Override
    public void callWalletInfo(String url,Context context) {
        if(testUseCase!=null){
            testUseCase.getWalletData(callback, url,context);
        }
    }

    private final BaseCallback callback = new BaseCallback() {
        @Override
        public void onSuccess() {

//            getView().initializeHomeList("success");
        }

        @Override
        public void onSuccess(Object model) {
            if (model instanceof TestResponseModel) {
                TestResponseModel response = (TestResponseModel) model;
//                if(response.pauseData!=null) {
//                    DebugMonitor.getLogger().d("reponse", new Gson().toJson(response.pauseData));
//                }
                if (response != null) {

                    Set<String> keys = response.sections.keySet();
                    ArrayList<TestAppModel> allData = new ArrayList<>();
                    TreeMap<Integer, SectionKeyValue> questionSet = new TreeMap<>();
                    Set<String> pauseKeys = null;
                    if (response.pauseData != null) {
                        pauseKeys = response.pauseData.tdata.keySet();

                    }
                    int totalPosition = 0;
                    for (int i = 0; i < keys.size(); i++) {
                        ArrayList<ArrayList<Object>> data = response.sections.get((String) keys.toArray()[i]);
                        questionSet.put(i, new SectionKeyValue((String) keys.toArray()[i], totalPosition));

                        for (int j = 0; j < data.size(); j++) {
//                            Log.d("Tag","yokkio>>>"+(String)data.get(j).get(5));

                            allData.add(new TestAppModel(totalPosition, (String) keys.toArray()[i], data.get(j), totalPosition, (String) data.get(j).get(0), ((String) data.get(j).get(5)).equals("1") ? true : false));

                            totalPosition++;
                        }


                    }
                    if (response.pauseData != null) {
                        try {

                            for (int j = 0; j < allData.size(); j++) {
                                if (allData.get(j).getQuestionId().equals(response.pauseData.lqn)) {
                                    response.switchToQuestion = j;
                                }

                                for (int k = 0; k < response.pauseData.tdata.size(); k++) {

                                    if (((String) pauseKeys.toArray()[k]).equals(allData.get(j).getQuestionId())) {
                                        allData.get(j).setPauseSession(response.pauseData.tdata.get((String) pauseKeys.toArray()[k]).getSessionInfo());
                                        allData.get(j).setSelectionOption((response.pauseData.tdata.get((String) pauseKeys.toArray()[k]).getOptionSelected().equals("") ? -1 : (Integer.parseInt(response.pauseData.tdata.get((String) pauseKeys.toArray()[k]).getOptionSelected()) - 1)));
                                        allData.get(j).setMarked((response.pauseData.tdata.get((String) pauseKeys.toArray()[k]).getsData().equals("11") ? true : false));

                                        break;
                                    }
                                }
                            }
                            response.settings.totalTime = Long.parseLong(response.pauseData.ltime);

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (getView() != null) {
                        getView().onTestDataCallback(response, allData, true, questionSet);
                    }
                } else {
                    if (getView() != null) {
                        getView().onTestDataCallback(response, null, false, null);
                    }
                }
            } else {
                if (getView() != null) {

                    getView().onSuccess(model);
                }
            }

        }

        @Override
        public void onSuccess(String response) {
            if (getView() != null) {

                getView().onSuccess(response);
            }
        }

        @Override
        public void onSolutionSuccess(TestResponseModel response) {
            int right = 0, wrong = 0;
            if (response != null) {
                Set<String> keys = response.sections.keySet();

                ArrayList<TestAppModel> allData = new ArrayList<>();
                TreeMap<Integer, SectionKeyValue> questionSet = new TreeMap<>();
                int totalPosition = 0;
                for (int i = 0; i < keys.size(); i++) {
                    ArrayList<ArrayList<Object>> data = response.sections.get((String) keys.toArray()[i]);
                    questionSet.put(i, new SectionKeyValue((String) keys.toArray()[i], totalPosition));

                    for (int j = 0; j < data.size(); j++) {

                             /*One time deception will happen here*/

                        ///////////////////////////////Decoding and decrpting data//////////////////////////////////////////

                        ArrayList<String> questionEncryptArray = (ArrayList<String>) data.get(j).get(1);
                        ArrayList<ArrayList<String>> answerEncryptArray = (ArrayList<ArrayList<String>>) data.get(j).get(2);
                        ArrayList<String> solutionEncryptArray = (ArrayList<String>) data.get(j).get(6);

                        try {
                            String solutionDecode = URLDecoder.decode(solutionEncryptArray.get(1), "UTF-8");
                            if (solutionDecode.length() > 0) {
                                solutionEncryptArray.set(1, decodeBase64(solutionDecode.substring(32, solutionDecode.length() - 32)));
                            }
                        } catch (Exception e) {

                            e.printStackTrace();

                        }


                        for (int l = 0; l < questionEncryptArray.size(); l++) {
                            try {
                                String questionDecoded = URLDecoder.decode(questionEncryptArray.get(l), "UTF-8");
                                if (questionDecoded.length() > 0) {
                                    questionEncryptArray.set(l, decodeBase64(questionDecoded.substring(32, questionDecoded.length() - 32)));
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }


                        for (int m = 0; m < answerEncryptArray.size(); m++) {
                            for (int k = 0; k < answerEncryptArray.get(m).size(); k++) {
                                try {

                                    String answerDecoded = URLDecoder.decode(answerEncryptArray.get(m).get(k), "UTF-8");
                                    if (answerDecoded.length() > 0) {
                                        answerEncryptArray.get(m).set(k, decodeBase64(answerDecoded.substring(32, answerDecoded.length() - 32)));
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }


                        }

                        data.get(j).set(1, questionEncryptArray);
                        data.get(j).set(2, answerEncryptArray);
                        data.get(j).set(6, solutionEncryptArray);

                        allData.add(new TestAppModel(totalPosition, (String) keys.toArray()[i], data.get(j), totalPosition, (String) data.get(j).get(0), (String) ((ArrayList<Object>) data.get(j).get(6)).get(2), ((String) data.get(j).get(5)).equals("1") ? true : false));
                        totalPosition++;
                        if (((String) ((ArrayList<Object>) data.get(j).get(6)).get(0)).equals((String) ((ArrayList<Object>) data.get(j).get(6)).get(2))) {
                            right = right + 1;
                        } else if (!(((String) ((ArrayList<Object>) data.get(j).get(6)).get(2)).toLowerCase().equals(Constants.UNATTEMPTED))) {
                            wrong = wrong + 1;
                        }
                    }


                }

                Set<String> painKeys = response.panes.keySet();
                for (int p = 0; p < response.panes.size(); p++) {
                    for (int q = 0; q < response.panes.get((String) painKeys.toArray()[p]).size(); q++) {
                        try {
                            String panesDecoded = URLDecoder.decode(response.panes.get((String) painKeys.toArray()[p]).get(q), "UTF-8");
                            if (panesDecoded.length() > 0) {
                                panesDecoded = decodeBase64(panesDecoded.substring(32, panesDecoded.length() - 32));
                                response.panes.get((String) painKeys.toArray()[p]).set(q, panesDecoded);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }

                }

///////////////////////////////////////////////Decoding end//////////////////////////////////////////////////////////////////////////////////////////////
                if (getView() != null) {
                    getView().onSolutionDataCallback(response, allData, true, questionSet, right, wrong, Double.isNaN((right * 100f) / (right + wrong)) ? "0 %" : String.format("%.02f", (right * 100f) / (right + wrong)) + " % ");
                }
            } else {
                if (getView() != null) {
                    getView().onSolutionDataCallback(response, null, false, null, 0, 0, "");
                }
            }
        }

        @Override
        public void onLoginSuccess(String token) {


        }

        @Override
        public void onAuthFailed() {
            getView().onAuthFailed();
        }

        @Override
        public void onFail() {
//            getView().initializeHomeList("fail");
            if (getView() != null) {
                getView().onFailed();
            }

        }

        @Override
        public void onFail(String message) {
            if (getView() != null) {
                getView().onFailed(message);
            }
        }

        @Override
        public void onSuccess(List model) {



            if (getView() != null) {
                getView().onSuccess(model);
            }




        }
    };

    private String decodeBase64(String coded) {
        byte[] valueDecoded = new byte[0];
        try {
            valueDecoded = Base64.decode(coded.getBytes("UTF-8"), Base64.DEFAULT);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new String(valueDecoded);
    }


}
