/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.telephony.TelephonyManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import in.oliveboard.sdk.presenter.model.SessionOut;
import in.oliveboard.sdk.ui.LoginOliveBoardActivity;
import in.oliveboard.sdk.utils.AppPreferences;
import in.oliveboard.sdk.utils.MainEventBus;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BasicConfig {
    public static BasicConfig basicConfig;

    public static synchronized BasicConfig getInstance() {
        if (basicConfig == null) {
            basicConfig = new BasicConfig();
        }
        return basicConfig;
    }

    public String getVersion(Context mContext) {
        String version = "2.2.0.9";
        return version;
    }

    public String getAuthData(Context mContext) {
        return new AppPreferences(mContext, "LoginPref").getData("token");
    }

    public String getAuthEmail(Context mContext) {
        return new AppPreferences(mContext, "LoginPref").getData("email");
    }

    public String getAuthPassword(Context mContext) {
        return new AppPreferences(mContext, "LoginPref").getData("password");
    }

    public boolean isLogin(Context mContext) {
        return new AppPreferences(mContext, "LoginPref").getBoolean("IsLoggedIn");
    }

    public String getDeviceId(Context mContext) {
        try {
            String devId = "";
            TelephonyManager telephony = (TelephonyManager)mContext.getSystemService("phone");
            devId = null != telephony && null != telephony.getDeviceId() ? telephony.getDeviceId() : Settings.Secure.getString((ContentResolver)mContext.getContentResolver(), (String)"android_id");
            try {
                devId = this.getmd5Checksum(devId, false);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            return devId;
        }
        catch (Exception e) {
            return "no_id";
        }
    }

    public String getmd5Checksum(String email, boolean isSocialLogin) throws NoSuchAlgorithmException {
        String key = email;
        if (isSocialLogin) {
            key = email + "OLIVEANDROID";
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(key.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            String hex = Integer.toHexString(0xFF & byteData[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public void apply(ViewGroup vg, String font, Context context) {
        try {
            Typeface type = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)font);
            for (int i = 0; i < vg.getChildCount(); ++i) {
                View v = vg.getChildAt(i);
                if (v instanceof TextView) {
                    ((TextView)v).setTypeface(type);
                    continue;
                }
                if (!(v instanceof ViewGroup)) continue;
                this.apply((ViewGroup)v, font, context);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String timeLeft(String time) {
        String[] h1 = time.split(":");
        return Integer.toString(Integer.parseInt(h1[2]) + 60 * Integer.parseInt(h1[1]) + 3600 * Integer.parseInt(h1[0]));
    }

    public void onAuthFailed(AppCompatActivity context) {
        ActivityCompat.finishAffinity((Activity)context);
        context.startActivity(new Intent((Context)context, LoginOliveBoardActivity.class).putExtra("com.auth.error", true));
        if (Build.VERSION.SDK_INT <= 15) {
            MainEventBus.getInstance().post((Object)new SessionOut());
        }
    }

    public void onAuthFailed(Fragment context) {
        ActivityCompat.finishAffinity((Activity)context.getActivity());
        context.startActivity(new Intent((Context)context.getActivity(), LoginOliveBoardActivity.class).putExtra("com.auth.error", true));
        if (Build.VERSION.SDK_INT <= 15) {
            MainEventBus.getInstance().post((Object)new SessionOut());
        }
    }
}

