/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.base.BaseFragment;
import in.oliveboard.sdk.utils.LargeDataHandler;

public class SolutionWebDetailFragment
extends BaseFragment {
    public WebView summeryWebView;
    public ProgressBar progressBar;
    LinearLayout tryAgainLayout;

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        this.view = inflater.inflate(this.getLayoutId(), container, false);
        if (this.presenter != null) {
            this.presenter.initialize(this.getArguments());
        }
        this.summeryWebView = (WebView)this.view.findViewById(R.id.web_view);
        this.progressBar = (ProgressBar)this.view.findViewById(R.id.progressbar_layer);
        this.tryAgainLayout = (LinearLayout)this.view.findViewById(R.id.try_again_layer);
        return this.view;
    }

    @Override
    protected void initializeDagger() {
    }

    @Override
    protected void initializePresenter() {
    }

    @Override
    protected void initializeActivity() {
        try {
            WebSettings settings = this.summeryWebView.getSettings();
            settings.setJavaScriptEnabled(true);
            this.progressBar.setVisibility(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tryAgainLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SolutionWebDetailFragment.this.progressBar != null) {
                    SolutionWebDetailFragment.this.progressBar.setVisibility(0);
                }
                if (SolutionWebDetailFragment.this.tryAgainLayout != null) {
                    SolutionWebDetailFragment.this.tryAgainLayout.setVisibility(8);
                }
                if (SolutionWebDetailFragment.this.summeryWebView != null) {
                    SolutionWebDetailFragment.this.summeryWebView.setVisibility(0);
                }
                if (LargeDataHandler.getInstance().getSummaryData() != null) {
                    SolutionWebDetailFragment.this.summeryWebView.loadUrl(LargeDataHandler.getInstance().getSummaryData().detailAnalysisWebView);
                }
            }
        });
        this.summeryWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return super.shouldOverrideUrlLoading(view, url);
            }

            public void onPageFinished(WebView view, String url) {
                try {
                    if (SolutionWebDetailFragment.this.isAdded() && SolutionWebDetailFragment.this.progressBar != null) {
                        SolutionWebDetailFragment.this.progressBar.setVisibility(8);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                try {
                    if (errorCode == -8 || errorCode == -6 || errorCode == -2) {
                        if (SolutionWebDetailFragment.this.progressBar != null) {
                            SolutionWebDetailFragment.this.progressBar.setVisibility(8);
                        }
                        if (SolutionWebDetailFragment.this.tryAgainLayout != null) {
                            SolutionWebDetailFragment.this.tryAgainLayout.setVisibility(0);
                        }
                        if (SolutionWebDetailFragment.this.summeryWebView != null) {
                            SolutionWebDetailFragment.this.summeryWebView.setVisibility(8);
                        }
                        view.loadData("retrying.....", "text/html", "utf-8");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (LargeDataHandler.getInstance().getSummaryData() != null) {
            this.summeryWebView.loadUrl(LargeDataHandler.getInstance().getSummaryData().detailAnalysisWebView);
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.fragment_webview_olivesdk;
    }

    public static SolutionWebDetailFragment newInstance() {
        return new SolutionWebDetailFragment();
    }
}

