/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.SwitchCompat;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.ChangeLanguage;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.ui.SolutionAppFilterActivity;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.ui.fragments.EmptyFragment;
import in.oliveboard.sdk.ui.fragments.TestSolutionViewPagerFragment;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.FilterAsyncTask;
import in.oliveboard.sdk.utils.FilterInterface;
import in.oliveboard.sdk.utils.FilterQuestions;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.TestDataChangeListener;
import in.oliveboard.sdk.utils.onDialogUtilCalled;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class TestSolutionActivity
extends BaseActivity
implements CommonContract.View,
FilterInterface,
TestDataChangeListener,
onDialogUtilCalled {
    Toolbar toolbar;
    TextView typeTextView;
    SwitchCompat languageSwitch;
    TextView hindiTextView;
    TextView englishTextView;
    View quickActionLineView;
    LinearLayout languageSwitchLayout;
    RelativeLayout emptyLayout;
    TextView examNameToolbarTextView;
    FloatingActionButton filterBtn;
    RelativeLayout typeRelativelayout;
    LinearLayout typeBottom;
    ImageView typeSection;
    Button summaryBtn;
    ArrayList<TestAppModel> questionAnswerInfo = new ArrayList();
    ArrayList<TestAppModel> filterQuestionArrayList = new ArrayList();
    TreeMap<Integer, SectionKeyValue> questionSet = new TreeMap();
    int selectedOption = 0;
    public static final int FILTER_TYPE = 1002;
    String totalTime;
    String totalQuestions;
    String testName;
    String accuracyString;
    String totalMark;
    int correctAnswer = 0;
    int wrongAnser = 0;
    TestPresenter presenter = new TestPresenter();

    @Override
    protected void initializeDagger() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.typeTextView = (TextView)this.findViewById(R.id.type_text_view);
        this.languageSwitch = (SwitchCompat)this.findViewById(R.id.switch_language);
        this.hindiTextView = (TextView)this.findViewById(R.id.hindi_txt);
        this.englishTextView = (TextView)this.findViewById(R.id.english_txt);
        this.quickActionLineView = this.findViewById(R.id.fine_line_view);
        this.languageSwitchLayout = (LinearLayout)this.findViewById(R.id.language_switch_layout);
        this.emptyLayout = (RelativeLayout)this.findViewById(R.id.empty);
        this.examNameToolbarTextView = (TextView)this.findViewById(R.id.test_txt);
        this.filterBtn = (FloatingActionButton)this.findViewById(R.id.filter_fab);
        this.typeRelativelayout = (RelativeLayout)this.findViewById(R.id.type_relative);
        this.typeBottom = (LinearLayout)this.findViewById(R.id.type_bottam);
        this.typeSection = (ImageView)this.findViewById(R.id.section);
        this.summaryBtn = (Button)this.findViewById(R.id.summery_btn);
        this.summaryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogUtils.getInstance().startSolutionSummeryDialog(TestSolutionActivity.this, TestSolutionActivity.this, TestSolutionActivity.this.totalTime, TestSolutionActivity.this.totalQuestions, TestSolutionActivity.this.testName, false, TestSolutionActivity.this.totalMark, TestSolutionActivity.this.correctAnswer, TestSolutionActivity.this.wrongAnser, TestSolutionActivity.this.accuracyString);
            }
        });
        this.filterBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LargeAppInfo.getInstance().setBaseFilterArray(TestSolutionActivity.this.questionAnswerInfo);
                TestSolutionActivity.this.startActivityForResult(new Intent(TestSolutionActivity.this.getApplicationContext(), SolutionAppFilterActivity.class).putExtra("data", "data"), 1002);
            }
        });
        this.typeTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TestSolutionActivity.this.questionSet.size() > 1) {
                    DialogUtils.getInstance().displayPopupWindow(TestSolutionActivity.this.quickActionLineView, TestSolutionActivity.this, TestSolutionActivity.this.questionSet, TestSolutionActivity.this, TestSolutionActivity.this.typeTextView.getText().toString());
                }
            }
        });
        this.typeRelativelayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TestSolutionActivity.this.questionSet.size() > 1) {
                    DialogUtils.getInstance().displayPopupWindow(TestSolutionActivity.this.quickActionLineView, TestSolutionActivity.this, TestSolutionActivity.this.questionSet, TestSolutionActivity.this, TestSolutionActivity.this.typeTextView.getText().toString());
                }
            }
        });
        this.typeBottom.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TestSolutionActivity.this.questionSet.size() > 1) {
                    DialogUtils.getInstance().displayPopupWindow(TestSolutionActivity.this.quickActionLineView, TestSolutionActivity.this, TestSolutionActivity.this.questionSet, TestSolutionActivity.this, TestSolutionActivity.this.typeTextView.getText().toString());
                }
            }
        });
        this.typeSection.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TestSolutionActivity.this.questionSet.size() > 1) {
                    DialogUtils.getInstance().displayPopupWindow(TestSolutionActivity.this.quickActionLineView, TestSolutionActivity.this, TestSolutionActivity.this.questionSet, TestSolutionActivity.this, TestSolutionActivity.this.typeTextView.getText().toString());
                }
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    protected void initializePresenter() {
        ((BaseActivity)this).presenter = this.presenter;
        this.presenter.setView(this);
        this.setSupportActionBar(this.toolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        if (this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL) != null && this.presenter != null) {
            this.showProgressDialog(this.getString(R.string.str_please_wait));
            this.presenter.callSolutionRequest(this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL), (Context)this);
        }
        this.languageSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if (b) {
                    LargeAppInfo.getInstance().setLanguageType(1);
                    TestSolutionActivity.this.englishTextView.setTextColor(ContextCompat.getColor((Context)TestSolutionActivity.this.getApplicationContext(), (int)R.color.light_grey));
                    TestSolutionActivity.this.hindiTextView.setTextColor(-16777216);
                    MainEventBus.getInstance().post((Object)new ChangeLanguage(1));
                } else {
                    LargeAppInfo.getInstance().setLanguageType(0);
                    TestSolutionActivity.this.englishTextView.setTextColor(-16777216);
                    TestSolutionActivity.this.hindiTextView.setTextColor(ContextCompat.getColor((Context)TestSolutionActivity.this.getApplicationContext(), (int)R.color.light_grey));
                    MainEventBus.getInstance().post((Object)new ChangeLanguage(0));
                }
            }
        });
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_solution_infinate_olivesdk;
    }

    public void setFragment(int position) {
        this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)TestSolutionViewPagerFragment.setInstance(position, false), "com.tag.fragment").commitAllowingStateLoss();
    }

    @Override
    public void onChangeFavorite(int position, boolean isFav) {
    }

    @Override
    public void onChangeOptionSelection(int position, int selectedPosition) {
        if (this.questionAnswerInfo != null && position < this.questionAnswerInfo.size()) {
            this.questionAnswerInfo.get(position).setAnswer(Integer.toString(selectedPosition));
        }
    }

    @Override
    public void onSessionReading(int position, String key) {
    }

    @Override
    public void onChangeQuestion(String key) {
        if (this.typeTextView != null && !this.typeTextView.getText().toString().equals(key)) {
            this.typeTextView.setText((CharSequence)key);
            this.selectedOption = FilterQuestions.getInstance().getQuestionSection(this.questionSet, key);
        }
    }

    @Override
    public void onLangaugeSwitchChange(boolean isVisible) {
        if (isVisible) {
            if (this.languageSwitchLayout.getVisibility() == 4) {
                this.languageSwitchLayout.setVisibility(0);
            }
        } else if (this.languageSwitchLayout.getVisibility() == 0) {
            this.languageSwitchLayout.setVisibility(4);
        }
    }

    @Override
    public void onChangeExpandData(int position, boolean isExpanded) {
        if (this.questionAnswerInfo != null && position < this.questionAnswerInfo.size()) {
            this.questionAnswerInfo.get(position).setExpanded(isExpanded);
        }
    }

    @Override
    public void onOptionDialogSelected(int position) {
        if (this.selectedOption != position) {
            this.selectedOption = position;
            this.typeTextView.setText((CharSequence)this.questionSet.get(this.selectedOption).getKey());
        }
        ((TestSolutionViewPagerFragment)this.getSupportFragmentManager().findFragmentByTag("com.tag.fragment")).changePosition(this.questionSet.get(position).getPosition());
    }

    @Override
    public void onAutoDialogSelected() {
    }

    @Override
    public void onSubmitDialogSelected() {
    }

    @Override
    public void onExitApp() {
        this.finish();
    }

    @Override
    public void onExitWithoutPause() {
    }

    @Override
    public void onTryAgain() {
    }

    @Override
    public void onPauseTest(boolean value) {
    }

    @Override
    public void startTest(boolean value) {
    }

    @Override
    public void retyPermission() {
    }

    @Override
    public void gotoPurchase() {
    }

    @Override
    public void noPhoneAction() {
    }

    @Override
    public void openPermissionSetting() {
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1002 && resultCode == -1) {
            if (data.getIntExtra("com.activity.result.filter.type", 0) == 0) {
                this.filterQuestionArrayList.clear();
                this.filterQuestionArrayList.addAll(this.questionAnswerInfo);
                this.questionSet.clear();
                this.questionSet.putAll(LargeAppInfo.getInstance().getQuestionSet());
                LargeAppInfo.getInstance().setCurrentQuestionInfo(this.filterQuestionArrayList);
                this.setFragment(data.getIntExtra("com.act.result.pos.filter", 0));
            } else if (data.getIntExtra("com.activity.result.filter.type", 0) == Constants.FILTER_CORRECT) {
                this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)new EmptyFragment(), "com.tag.fragment").commitAllowingStateLoss();
                new FilterAsyncTask(0, Constants.FILTER_CORRECT_TYPE, this.questionAnswerInfo, this, data.getIntExtra("com.act.result.pos.filter", 0)).execute(new Void[0]);
            } else if (data.getIntExtra("com.activity.result.filter.type", 0) == Constants.FILTER_WRONG) {
                this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)new EmptyFragment(), "com.tag.fragment").commitAllowingStateLoss();
                new FilterAsyncTask(0, Constants.FILTER_WRONG_TYPE, this.questionAnswerInfo, this, data.getIntExtra("com.act.result.pos.filter", 0)).execute(new Void[0]);
            } else {
                this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)new EmptyFragment(), "com.tag.fragment").commitAllowingStateLoss();
                new FilterAsyncTask(0, Constants.FILTER_UN_ATTEMPTED_TYPE, this.questionAnswerInfo, this, data.getIntExtra("com.act.result.pos.filter", 0)).execute(new Void[0]);
            }
        }
    }

    @Override
    public void ongetFilterResult(ArrayList<FilterModel> filterInfo, int position) {
        if (filterInfo != null && filterInfo.size() > 0) {
            this.filterQuestionArrayList.clear();
            this.questionSet.clear();
            this.questionSet.putAll(filterInfo.get(0).getSortOrder());
            this.filterQuestionArrayList.addAll(filterInfo.get(0).getFilterArrayList());
            LargeAppInfo.getInstance().setCurrentQuestionInfo(this.filterQuestionArrayList);
            this.setFragment(position);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        LargeAppInfo.getInstance().clearAllData();
        if (this.presenter != null) {
            this.presenter.unSubscribe();
        }
    }

    public void onSuccess(Object responseModel) {
    }

    @Override
    public void onFailed() {
        this.hideProgressDialog();
        this.finish();
    }

    public void onSuccess(List responseModel) {
    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onSuccess(String response) {
    }

    public void onSolutionDataCallback(TestResponseModel response, ArrayList solutionList, boolean status, TreeMap questionSets, int correct, int wrong, String accurecy) {
        this.hideProgressDialog();
        if (status) {
            if (response != null) {
                if (solutionList != null) {
                    this.questionAnswerInfo.clear();
                    this.questionAnswerInfo.addAll(solutionList);
                    LargeAppInfo.getInstance().setCurrentQuestionInfo(this.questionAnswerInfo);
                    LargeAppInfo.getInstance().setQuestionSize(this.questionAnswerInfo.size());
                    if (questionSets != null) {
                        this.questionSet.clear();
                        this.questionSet.putAll(questionSets);
                        LargeAppInfo.getInstance().setQuestionSet(questionSets);
                        this.typeTextView.setText((CharSequence)this.questionSet.get(0).getKey());
                    }
                    LargeAppInfo.getInstance().setPanesList(response.panes);
                }
                if (this.questionAnswerInfo.size() == 0) {
                    this.finish();
                } else {
                    this.emptyLayout.setVisibility(8);
                    this.setFragment(0);
                    this.testName = response.questionId;
                    this.totalMark = response.total;
                    this.accuracyString = accurecy;
                    this.correctAnswer = correct;
                    this.wrongAnser = wrong;
                    this.examNameToolbarTextView.setText((CharSequence)this.testName);
                    this.totalTime = response.settings.totalTimeString;
                    this.totalQuestions = Integer.toString(response.settings.numberOfQuestion);
                }
            } else {
                this.finish();
            }
        } else {
            this.finish();
        }
    }

    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    @Override
    public void onFailed(String message) {
    }
}

